/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.logger;

import java.io.PrintWriter;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.ignite.rest.client.invoker.ApiClient;

class HttpLogging {
    private final ApiClient client;
    private HttpLoggingInterceptor interceptor;

    HttpLogging(ApiClient client) {
        this.client = client;
    }

    void startHttpLogging(PrintWriter output) {
        if (this.interceptor == null) {
            OkHttpClient.Builder builder = this.client.getHttpClient().newBuilder();
            this.interceptor = new HttpLoggingInterceptor(output::println);
            this.interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            builder.interceptors().add(this.interceptor);
            this.client.setHttpClient(builder.build());
        }
    }

    void stopHttpLogging() {
        if (this.interceptor != null) {
            OkHttpClient.Builder builder = this.client.getHttpClient().newBuilder();
            builder.interceptors().remove(this.interceptor);
            this.client.setHttpClient(builder.build());
        }
    }
}

