/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.errors;

import com.fasterxml.jackson.annotation.JsonValue;
import io.micronaut.security.errors.ErrorCode;

public enum IssuingAnAccessTokenErrorCode implements ErrorCode
{
    INVALID_REQUEST("invalid_request", "The request is missing a required parameter, includes an unsupported parameter value (other than grant type), repeats a parameter, includes multiple credentials, utilizes more than one mechanism for authenticating the client, or is otherwise malformed."),
    INVALID_CLIENT("invalid_client", "Client authentication failed (e.g., unknown client, no client authentication included, or unsupported authentication method). The authorization server MAY return an HTTP 401 (Unauthorized) status code to indicate which HTTP authentication schemes are supported.  If the client attempted to authenticate via the \"Authorization\" request header field, the authorization server MUST respond with an HTTP 401 (Unauthorized) status code and include the \"WWW-Authenticate\" response header field matching the authentication scheme used by the client."),
    INVALID_GRANT("invalid_grant", "The provided authorization grant (e.g., authorization code, resource owner credentials) or refresh token is invalid, expired, revoked, does not match the redirection URI used in the authorization request, or was issued to another client."),
    UNAUTHORIZED_CLIENT("unauthorized_client", "The authenticated client is not authorized to use this authorization grant type."),
    UNSUPPORTED_GRANT_TYPE("unsupported_grant_type", "The authorization grant type is not supported by the authorization server.");

    private String errorCode;
    private String errorCodeDescription;

    private IssuingAnAccessTokenErrorCode(String errorCode, String errorCodeDescription) {
        this.errorCode = errorCode;
        this.errorCodeDescription = errorCodeDescription;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorCodeDescription() {
        return this.errorCodeDescription;
    }

    @JsonValue
    public String toString() {
        return this.errorCode;
    }
}

