/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.AlterZoneEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.Node;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.rebalance.DistributionZoneRebalanceEngine;
import org.apache.ignite.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite.internal.distributionzones.utils.CatalogAlterZoneEventListener;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

public class DistributionZoneRebalanceEngineV2 {
    private static final IgniteLogger LOG = Loggers.forClass(DistributionZoneRebalanceEngine.class);
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock;
    private final MetaStorageManager metaStorageManager;
    private final DistributionZoneManager distributionZoneManager;
    private final WatchListener dataNodesListener;
    private final CatalogService catalogService;

    public DistributionZoneRebalanceEngineV2(IgniteSpinBusyLock busyLock, MetaStorageManager metaStorageManager, DistributionZoneManager distributionZoneManager, CatalogManager catalogService) {
        this.busyLock = busyLock;
        this.metaStorageManager = metaStorageManager;
        this.distributionZoneManager = distributionZoneManager;
        this.catalogService = catalogService;
        this.dataNodesListener = this.createDistributionZonesDataNodesListener();
    }

    public CompletableFuture<Void> startAsync() {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.catalogService.listen((Event)CatalogEvent.ZONE_ALTER, (EventListener)new CatalogAlterZoneEventListener(this.catalogService){

                @Override
                protected CompletableFuture<Void> onReplicasUpdate(AlterZoneEventParameters parameters, int oldReplicas) {
                    return DistributionZoneRebalanceEngineV2.this.onUpdateReplicas(parameters);
                }
            });
            this.metaStorageManager.registerPrefixWatch(DistributionZonesUtil.zoneDataNodesKey(), this.dataNodesListener);
            CompletableFuture recoveryFinishFuture = this.metaStorageManager.recoveryFinishedFuture();
            assert (recoveryFinishFuture.isDone());
            long recoveryRevision = ((Revisions)recoveryFinishFuture.join()).revision();
            return this.rebalanceTriggersRecovery(recoveryRevision);
        });
    }

    public void stop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.metaStorageManager.unregisterWatch(this.dataNodesListener);
    }

    private WatchListener createDistributionZonesDataNodesListener() {
        return evt -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            Set<Node> dataNodes = DistributionZonesUtil.parseDataNodes(evt.entryEvent().newEntry().value());
            if (dataNodes == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            int zoneId = ZoneRebalanceUtil.extractZoneIdDataNodes(evt.entryEvent().newEntry().key());
            int catalogVersion = this.catalogService.latestCatalogVersion();
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            long assignmentsTimestamp = catalog.time();
            CatalogZoneDescriptor zoneDescriptor = this.catalogService.zone(zoneId, catalogVersion);
            if (zoneDescriptor == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            Map<UUID, NodeWithAttributes> nodesAttributes = this.distributionZoneManager.nodesAttributes();
            Set<String> filteredDataNodes = DistributionZonesUtil.filterDataNodes(dataNodes, zoneDescriptor, nodesAttributes);
            if (LOG.isInfoEnabled()) {
                ArrayList<NodeWithAttributes> matchedNodes = new ArrayList<NodeWithAttributes>();
                ArrayList<NodeWithAttributes> filteredOutNodes = new ArrayList<NodeWithAttributes>();
                for (Node dataNode : dataNodes) {
                    NodeWithAttributes nodeWithAttributes = nodesAttributes.get(dataNode.nodeId());
                    if (filteredDataNodes.contains(dataNode.nodeName())) {
                        matchedNodes.add(nodeWithAttributes);
                        continue;
                    }
                    filteredOutNodes.add(nodeWithAttributes);
                }
                if (!filteredOutNodes.isEmpty()) {
                    LOG.info("Some data nodes were filtered out because they don't match zone's attributes:\n\tzoneId={}\n\tfilter={}\n\tstorageProfiles={}'\n\tfilteredOutNodes={}\n\tremainingNodes={}", new Object[]{zoneDescriptor.id(), zoneDescriptor.filter(), zoneDescriptor.storageProfiles(), filteredOutNodes, matchedNodes});
                }
            }
            if (filteredDataNodes.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            long revision = evt.entryEvent().newEntry().revision();
            Set<String> aliveNodes = this.distributionZoneManager.logicalTopology(revision).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
            return ZoneRebalanceUtil.triggerZonePartitionsRebalance(zoneDescriptor, filteredDataNodes, revision, this.metaStorageManager, this.busyLock, assignmentsTimestamp, aliveNodes);
        });
    }

    private CompletableFuture<Void> onUpdateReplicas(AlterZoneEventParameters parameters) {
        return this.recalculateAssignmentsAndTriggerZonePartitionsRebalance(parameters.zoneDescriptor(), parameters.causalityToken(), parameters.catalogVersion());
    }

    private CompletableFuture<Void> recalculateAssignmentsAndTriggerZonePartitionsRebalance(CatalogZoneDescriptor zoneDescriptor, long causalityToken, int catalogVersion) {
        return this.distributionZoneManager.dataNodes(causalityToken, catalogVersion, zoneDescriptor.id()).thenCompose(dataNodes -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            if (dataNodes.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            Set<String> aliveNodes = this.distributionZoneManager.logicalTopology(causalityToken).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
            return ZoneRebalanceUtil.triggerZonePartitionsRebalance(zoneDescriptor, dataNodes, causalityToken, this.metaStorageManager, this.busyLock, catalog.time(), aliveNodes);
        }));
    }

    private CompletableFuture<Void> rebalanceTriggersRecovery(long recoveryRevision) {
        if (recoveryRevision > 0L) {
            List<CompletableFuture> zonesRecoveryFutures = this.catalogService.zones(this.catalogService.latestCatalogVersion()).stream().map(zoneDesc -> this.recalculateAssignmentsAndTriggerZonePartitionsRebalance((CatalogZoneDescriptor)zoneDesc, recoveryRevision, this.catalogService.latestCatalogVersion())).collect(Collectors.toUnmodifiableList());
            return CompletableFuture.allOf(zonesRecoveryFutures.toArray(new CompletableFuture[0]));
        }
        return CompletableFuture.completedFuture(null);
    }
}

