/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.SortOrder;
import org.apache.ignite.catalog.annotations.Column;
import org.apache.ignite.catalog.annotations.ColumnRef;
import org.apache.ignite.catalog.annotations.Id;
import org.apache.ignite.catalog.annotations.Index;
import org.apache.ignite.catalog.annotations.Table;
import org.apache.ignite.catalog.annotations.Zone;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.CreateTableImpl;
import org.apache.ignite.internal.catalog.sql.CreateZoneImpl;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryUtils;
import org.apache.ignite.internal.catalog.sql.TableZoneId;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.mapper.Mapper;

class CreateFromAnnotationsImpl
extends AbstractCatalogQuery<TableZoneId> {
    private CreateZoneImpl createZone;
    private String zoneName;
    private CreateTableImpl createTable;
    private String tableName;
    private IndexType pkType;

    CreateFromAnnotationsImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected TableZoneId result() {
        return new TableZoneId(this.tableName, this.zoneName);
    }

    CreateFromAnnotationsImpl processKeyValueClasses(Class<?> keyClass, Class<?> valueClass) {
        if (keyClass.getAnnotation(Table.class) == null && valueClass.getAnnotation(Table.class) == null) {
            throw new IllegalArgumentException("Cannot find @Table annotation neither on " + keyClass.getName() + " nor on " + valueClass.getName() + ". At least one of these classes must be annotated in order to create a query object.");
        }
        this.processAnnotations(keyClass, true);
        this.processAnnotations(valueClass, false);
        return this;
    }

    CreateFromAnnotationsImpl processRecordClass(Class<?> recordCls) {
        if (recordCls.getAnnotation(Table.class) == null) {
            throw new IllegalArgumentException("Cannot find @Table annotation on " + recordCls.getName() + ". This class must be annotated with in order to create a query object.");
        }
        this.processAnnotations(recordCls, true);
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (this.createZone != null) {
            ctx.visit(this.createZone).formatSeparator();
        }
        if (this.createTable != null) {
            ctx.visit(this.createTable).formatSeparator();
        }
    }

    private void processAnnotations(Class<?> clazz, boolean isKeyClass) {
        Table table;
        if (this.createTable == null) {
            this.createTable = new CreateTableImpl(this.sql).ifNotExists();
        }
        if ((table = clazz.getAnnotation(Table.class)) != null) {
            String tableName = table.value().isEmpty() ? clazz.getSimpleName() : table.value();
            this.createTable.name(table.schemaName(), tableName);
            this.tableName = tableName;
            this.processZone(table);
            this.processTable(table);
        }
        CreateFromAnnotationsImpl.processColumns(this.createTable, this.pkType, clazz, isKeyClass);
    }

    private void processZone(Table table) {
        Zone zone = table.zone();
        if (zone != null && !"Default".equalsIgnoreCase(zone.value())) {
            String zoneName;
            this.createZone = new CreateZoneImpl(this.sql).ifNotExists();
            this.zoneName = zoneName = zone.value();
            this.createTable.zone(zoneName);
            this.createZone.name(zoneName);
            this.createZone.storageProfiles(zone.storageProfiles());
            if (zone.partitions() > 0) {
                this.createZone.partitions(zone.partitions());
            }
            if (zone.replicas() > 0) {
                this.createZone.replicas(zone.replicas());
            }
            if (!zone.distributionAlgorithm().isEmpty()) {
                this.createZone.distributionAlgorithm(zone.distributionAlgorithm());
            }
            if (zone.dataNodesAutoAdjust() > 0) {
                this.createZone.dataNodesAutoAdjust(zone.dataNodesAutoAdjust());
            }
            if (zone.dataNodesAutoAdjustScaleUp() > 0) {
                this.createZone.dataNodesAutoAdjustScaleUp(zone.dataNodesAutoAdjustScaleUp());
            }
            if (zone.dataNodesAutoAdjustScaleDown() > 0) {
                this.createZone.dataNodesAutoAdjustScaleDown(zone.dataNodesAutoAdjustScaleDown());
            }
            if (!zone.filter().isEmpty()) {
                this.createZone.filter(zone.filter());
            }
            if (!zone.consistencyMode().isEmpty()) {
                this.createZone.consistencyMode(zone.consistencyMode());
            }
        }
    }

    private void processTable(Table table) {
        for (Index ix : table.indexes()) {
            List<ColumnSorted> indexColumns = QueryUtils.mapArrayToList(ix.columns(), col -> ColumnSorted.column((String)col.value(), (SortOrder)col.sort()));
            String name = CreateFromAnnotationsImpl.toIndexName(ix);
            this.createTable.addIndex(name, ix.type(), indexColumns);
        }
        ColumnRef[] colocateBy = table.colocateBy();
        if (colocateBy != null && colocateBy.length > 0) {
            this.createTable.colocateBy(QueryUtils.mapArrayToList(colocateBy, ColumnRef::value));
        }
        this.pkType = table.primaryKeyType();
    }

    private static String toIndexName(Index ix) {
        if (!ix.value().isEmpty()) {
            return ix.value();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("ix");
        for (ColumnRef columnRef : ix.columns()) {
            list.add(columnRef.value());
        }
        return String.join((CharSequence)"_", list);
    }

    static void processColumns(CreateTableImpl createTable, IndexType pkType, Class<?> clazz, boolean isKeyClass) {
        ArrayList<ColumnSorted> idColumns = new ArrayList<ColumnSorted>();
        if (Mapper.nativelySupported(clazz)) {
            String columnName;
            String string = columnName = isKeyClass ? "id" : "val";
            if (isKeyClass) {
                idColumns.add(ColumnSorted.column((String)columnName));
            }
            createTable.addColumn(columnName, ColumnType.of(clazz));
        } else {
            CreateFromAnnotationsImpl.processColumnsInPojo(createTable, clazz, idColumns);
        }
        if (!idColumns.isEmpty()) {
            createTable.primaryKey(pkType, idColumns);
        }
    }

    private static void processColumnsInPojo(CreateTableImpl createTable, Class<?> clazz, List<ColumnSorted> idColumns) {
        for (Field f : clazz.getDeclaredFields()) {
            String columnName;
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            Column column = f.getAnnotation(Column.class);
            if (column == null) {
                columnName = f.getName();
                createTable.addColumn(columnName, ColumnType.of(f.getType()));
            } else {
                String string = columnName = column.value().isEmpty() ? f.getName() : column.value();
                if (!column.columnDefinition().isEmpty()) {
                    createTable.addColumn(columnName, column.columnDefinition());
                } else {
                    ColumnType type = ColumnType.of(f.getType(), (Integer)column.length(), (Integer)column.precision(), (Integer)column.scale(), (Boolean)column.nullable());
                    createTable.addColumn(columnName, type);
                }
            }
            Id id = f.getAnnotation(Id.class);
            if (id == null) continue;
            idColumns.add(ColumnSorted.column((String)columnName, (SortOrder)id.value()));
        }
    }
}

