/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.Objects;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class ColumnParams {
    public static final String ERR_COL_PARAM_NOT_APPLICABLE = "{} is not applicable for column '{}' of type '{}'.";
    public static final String ERR_COL_PARAM_DEFINITION = "{} definition is necessary for column '{}' of type '{}'.";
    public static final String ERR_COL_INVALID_TYPE_PARAM = "{} for column `{}` of type {} {} must be between {} and {}.";
    private String name;
    private ColumnType type;
    private boolean nullable;
    @Nullable
    private Integer length;
    @Nullable
    private Integer precision;
    @Nullable
    private Integer scale;
    private DefaultValue defaultValueDefinition = DefaultValue.constant(null);

    public static Builder builder() {
        return new Builder();
    }

    private ColumnParams() {
    }

    public String name() {
        return this.name;
    }

    public ColumnType type() {
        return this.type;
    }

    public <T extends DefaultValue> T defaultValueDefinition() {
        return (T)this.defaultValueDefinition;
    }

    public boolean nullable() {
        return this.nullable;
    }

    @Nullable
    public Integer precision() {
        return this.precision;
    }

    @Nullable
    public Integer scale() {
        return this.scale;
    }

    @Nullable
    public Integer length() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnParams that = (ColumnParams)o;
        return this.nullable == that.nullable && Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.length, that.length) && Objects.equals(this.precision, that.precision) && Objects.equals(this.scale, that.scale) && Objects.equals(this.defaultValueDefinition, that.defaultValueDefinition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.nullable, this.length, this.precision, this.scale, this.defaultValueDefinition});
    }

    private static void validateTypeParameter(String colName, ColumnType type, String paramName, @Nullable Integer value, int min, int max) {
        if (value == null) {
            throw new CatalogValidationException(ERR_COL_PARAM_DEFINITION, new Object[]{paramName, colName, type});
        }
        if (value < min || value > max) {
            throw new CatalogValidationException(ERR_COL_INVALID_TYPE_PARAM, new Object[]{paramName, colName, type, value, min, max});
        }
    }

    public static class Builder {
        private ColumnParams params = new ColumnParams();

        private Builder() {
        }

        public Builder name(String name) {
            this.params.name = name;
            return this;
        }

        public Builder type(ColumnType type) {
            this.params.type = type;
            return this;
        }

        public Builder nullable(boolean nullable) {
            this.params.nullable = nullable;
            return this;
        }

        public Builder defaultValue(DefaultValue defaultValue) {
            this.params.defaultValueDefinition = defaultValue;
            return this;
        }

        public Builder precision(@Nullable Integer precision) {
            this.params.precision = precision;
            return this;
        }

        public Builder scale(@Nullable Integer scale) {
            this.params.scale = scale;
            return this;
        }

        public Builder length(@Nullable Integer length) {
            this.params.length = length;
            return this;
        }

        public ColumnParams build() {
            this.validate();
            ColumnParams params0 = this.params;
            this.params = null;
            return params0;
        }

        private void validate() {
            CatalogParamsValidationUtils.validateIdentifier(this.params.name(), "Column name");
            if (this.params.type == null) {
                throw new CatalogValidationException("Type is not specified for column '{}'", this.params.name());
            }
            if (this.params.type == ColumnType.NULL) {
                throw new CatalogValidationException("Type NULL is not applicable for column '{}'", this.params.name());
            }
            boolean validatePrecision = this.params.type.precisionAllowed();
            boolean validateScale = this.params.type.scaleAllowed();
            boolean validateLength = this.params.type.lengthAllowed();
            if (validateLength) {
                Builder.validateLength(this.params);
            } else if (this.params.length() != null) {
                throw new CatalogValidationException(ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, new Object[]{"Length", this.params.name(), this.params.type()});
            }
            if (validatePrecision) {
                Builder.validatePrecision(this.params);
                if (this.params.scale() != null && !validateScale) {
                    throw new CatalogValidationException(ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, new Object[]{"Scale", this.params.name(), this.params.type()});
                }
            }
            if (validateScale) {
                Builder.validateScale(this.params);
            }
            if (!validatePrecision && !validateScale) {
                if (this.params.precision() != null) {
                    throw new CatalogValidationException(ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, new Object[]{"Precision", this.params.name(), this.params.type()});
                }
                if (this.params.scale() != null) {
                    throw new CatalogValidationException(ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, new Object[]{"Scale", this.params.name(), this.params.type()});
                }
            }
        }

        private static void validateLength(ColumnParams params) {
            Integer length = params.length();
            String name = params.name();
            ColumnType type = params.type();
            int minLength = CatalogUtils.getMinLength(type);
            int maxLength = CatalogUtils.getMaxLength(type);
            ColumnParams.validateTypeParameter(name, type, "Length", length, minLength, maxLength);
        }

        private static void validatePrecision(ColumnParams params) {
            Integer precision = params.precision();
            String name = params.name();
            ColumnType type = params.type();
            int minPrecision = CatalogUtils.getMinPrecision(type);
            int maxPrecision = CatalogUtils.getMaxPrecision(type);
            ColumnParams.validateTypeParameter(name, type, "Precision", precision, minPrecision, maxPrecision);
        }

        private static void validateScale(ColumnParams params) {
            Integer scale = params.scale();
            String name = params.name();
            ColumnType type = params.type();
            int minScale = CatalogUtils.getMinScale(type);
            int maxScale = CatalogUtils.getMaxScale(type);
            ColumnParams.validateTypeParameter(name, type, "Scale", scale, minScale, maxScale);
        }
    }
}

