/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AddWriteResultStatus;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class AddWriteResult {
    private final AddWriteResultStatus status;
    @Nullable
    private final BinaryRow previousWriteIntent;
    @Nullable
    private final UUID currentWriteIntentTxId;
    @Nullable
    private final HybridTimestamp latestCommitTimestamp;

    private AddWriteResult(AddWriteResultStatus status, @Nullable BinaryRow previousWriteIntent, @Nullable UUID currentWriteIntentTxId, @Nullable HybridTimestamp latestCommitTimestamp) {
        this.status = status;
        this.previousWriteIntent = previousWriteIntent;
        this.currentWriteIntentTxId = currentWriteIntentTxId;
        this.latestCommitTimestamp = latestCommitTimestamp;
    }

    public static AddWriteResult success(@Nullable BinaryRow previousWriteIntent) {
        return new AddWriteResult(AddWriteResultStatus.SUCCESS, previousWriteIntent, null, null);
    }

    public static AddWriteResult txMismatch(UUID currentWriteIntentTxId, @Nullable HybridTimestamp latestCommitTimestamp) {
        return new AddWriteResult(AddWriteResultStatus.TX_MISMATCH, null, currentWriteIntentTxId, latestCommitTimestamp);
    }

    public AddWriteResultStatus status() {
        return this.status;
    }

    @Nullable
    public BinaryRow previousWriteIntent() {
        return this.previousWriteIntent;
    }

    @Nullable
    public UUID currentWriteIntentTxId() {
        return this.currentWriteIntentTxId;
    }

    @Nullable
    public HybridTimestamp latestCommitTimestamp() {
        return this.latestCommitTimestamp;
    }

    public String toString() {
        return S.toString(this);
    }
}

