/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.CipherHandler;
import com.amazonaws.encryptionsdk.internal.CryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.CipherBlockHeaders;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

class BlockEncryptionHandler
implements CryptoHandler {
    private static final SecureRandom RND = new SecureRandom();
    private final SecretKey encryptionKey_;
    private final CryptoAlgorithm cryptoAlgo_;
    private final int nonceLen_;
    private final byte[] messageId_;
    private final int tagLenBytes_;
    private final ByteArrayOutputStream bytesToEncryptStream_ = new ByteArrayOutputStream(1024);
    private boolean complete_ = false;

    public BlockEncryptionHandler(SecretKey encryptionKey, int nonceLen, CryptoAlgorithm cryptoAlgo, byte[] messageId) {
        this.encryptionKey_ = encryptionKey;
        this.cryptoAlgo_ = cryptoAlgo;
        this.nonceLen_ = nonceLen;
        this.messageId_ = (byte[])messageId.clone();
        this.tagLenBytes_ = this.cryptoAlgo_.getTagLen();
    }

    @Override
    public ProcessingSummary processBytes(byte[] in, int off, int len, byte[] out, int outOff) {
        this.bytesToEncryptStream_.write(in, off, len);
        return new ProcessingSummary(0, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws BadCiphertextException {
        this.complete_ = true;
        return this.writeEncryptedBlock(this.bytesToEncryptStream_.toByteArray(), 0, this.bytesToEncryptStream_.size(), out, outOff);
    }

    @Override
    public int estimateOutputSize(int inLen) {
        int outSize = 0;
        outSize += this.nonceLen_ + this.tagLenBytes_;
        outSize += 8;
        outSize += this.bytesToEncryptStream_.size();
        if (inLen > 0) {
            outSize += inLen;
        }
        return outSize;
    }

    @Override
    public int estimatePartialOutputSize(int inLen) {
        return 0;
    }

    @Override
    public int estimateFinalOutputSize() {
        return this.estimateOutputSize(0);
    }

    private int writeEncryptedBlock(byte[] input, int off, int len, byte[] out, int outOff) throws BadCiphertextException {
        if (out.length == 0) {
            return 0;
        }
        int outLen = 0;
        boolean seqNum = true;
        byte[] contentAad = Utils.generateContentAad(this.messageId_, "AWSKMSEncryptionClient Single Block", 1, len);
        byte[] nonce = this.getNonce();
        byte[] encryptedBytes = new CipherHandler(this.encryptionKey_, 1, this.cryptoAlgo_).cipherData(nonce, contentAad, input, off, len);
        int encryptedContentLen = encryptedBytes.length - this.tagLenBytes_;
        CipherBlockHeaders cipherBlockHeaders = new CipherBlockHeaders(nonce, encryptedContentLen);
        byte[] cipherBlockHeaderBytes = cipherBlockHeaders.toByteArray();
        System.arraycopy(cipherBlockHeaderBytes, 0, out, outOff + outLen, cipherBlockHeaderBytes.length);
        System.arraycopy(encryptedBytes, 0, out, outOff + (outLen += cipherBlockHeaderBytes.length), encryptedBytes.length);
        return outLen += encryptedBytes.length;
    }

    private byte[] getNonce() {
        byte[] nonce = new byte[this.nonceLen_];
        nonce[nonce.length - 1] = 1;
        return nonce;
    }

    @Override
    public boolean isComplete() {
        return this.complete_;
    }
}

