/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.freelist;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageInsertFragmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageInsertRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageRemoveRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageUpdateRecord;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.Storable;
import org.apache.ignite.internal.processors.cache.persistence.evict.PageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.freelist.CorruptedFreeListException;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.LongListReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.GridCursorIteratorWrapper;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class AbstractFreeList<T extends Storable>
extends PagesList
implements FreeList<T>,
ReuseList {
    private static final int BUCKETS = 256;
    private static final int REUSE_BUCKET = 255;
    private static final Integer COMPLETE = Integer.MAX_VALUE;
    private static final Integer FAIL_I = Integer.MIN_VALUE;
    private static final Long FAIL_L = Long.MAX_VALUE;
    private static final int MIN_PAGE_FREE_SPACE = 8;
    private final int shift;
    private final AtomicReferenceArray<PagesList.Stripe[]> buckets = new AtomicReferenceArray(256);
    private final AtomicReferenceArray<PagesList.PagesCache> bucketCaches = new AtomicReferenceArray(256);
    private final int MIN_SIZE_FOR_DATA_PAGE;
    private final PageHandler<T, Boolean> updateRow = new UpdateRowHandler();
    private final DataRegionMetricsImpl memMetrics;
    private final PageEvictionTracker evictionTracker;
    private final AtomicLong pageListCacheLimit;
    private final WriteRowHandler writeRowHnd = new WriteRowHandler();
    private final WriteRowsHandler writeRowsHnd = new WriteRowsHandler();
    private final PageHandler<ReuseBag, Long> rmvRow;

    public AbstractFreeList(int cacheId, String name, DataRegionMetricsImpl memMetrics, DataRegion memPlc, ReuseList reuseList, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew, PageLockListener lockLsnr, GridKernalContext ctx, AtomicLong pageListCacheLimit, byte pageFlag) throws IgniteCheckedException {
        super(cacheId, name, memPlc.pageMemory(), 256, wal, metaPageId, lockLsnr, ctx, pageFlag);
        int pageSize;
        this.rmvRow = new RemoveRowHandler(cacheId == 0);
        this.evictionTracker = memPlc.evictionTracker();
        this.reuseList = reuseList == null ? this : reuseList;
        assert (U.isPow2(pageSize)) : "Page size must be a power of 2: " + pageSize;
        assert (U.isPow2(256));
        assert (256 <= pageSize) : pageSize;
        this.MIN_SIZE_FOR_DATA_PAGE = pageSize - 66;
        int shift = 0;
        for (pageSize = this.pageMem.pageSize(); pageSize > 256; pageSize >>>= 1) {
            ++shift;
        }
        this.shift = shift;
        this.memMetrics = memMetrics;
        this.pageListCacheLimit = pageListCacheLimit;
        this.init(metaPageId, initNew);
    }

    public long freeSpace() {
        long freeSpace = 0L;
        for (int b = 254; b > 0; --b) {
            long perPageFreeSpace = b << this.shift;
            long pages = this.bucketsSize.get(b);
            freeSpace += pages * perPageFreeSpace;
        }
        return freeSpace;
    }

    @Override
    public void dumpStatistics(IgniteLogger log) {
        long dataPages = 0L;
        boolean dumpBucketsInfo = false;
        for (int b = 0; b < 256; ++b) {
            long size = this.bucketsSize.get(b);
            if (this.isReuseBucket(b)) continue;
            dataPages += size;
        }
        if (dataPages > 0L && log.isInfoEnabled()) {
            log.info("FreeList [name=" + this.name + ", buckets=" + 256 + ", dataPages=" + dataPages + ", reusePages=" + this.bucketsSize.get(255) + "]");
        }
    }

    private int bucket(int freeSpace, boolean allowReuse) {
        assert (freeSpace > 0) : freeSpace;
        int bucket = freeSpace >>> this.shift;
        assert (bucket >= 0 && bucket < 256) : bucket;
        if (!allowReuse && this.isReuseBucket(bucket)) {
            --bucket;
        }
        return bucket;
    }

    @Override
    protected int getBucketIndex(int freeSpace) {
        return freeSpace > 8 ? this.bucket(freeSpace, false) : -1;
    }

    private long allocateDataPage(int part) throws IgniteCheckedException {
        assert (part <= 65500);
        return this.pageMem.allocatePage(this.grpId, part, (byte)1);
    }

    @Override
    public void insertDataRow(T row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        int written = 0;
        try {
            do {
                if (written == 0) continue;
                this.memMetrics.incrementLargeEntriesPages();
            } while ((written = this.writeSinglePage(row, written, statHolder)) != COMPLETE);
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to insert data row", t);
        }
    }

    @Override
    public void insertDataRows(Collection<T> rows, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        try {
            GridCursorIteratorWrapper<T> cur = new GridCursorIteratorWrapper<T>(rows.iterator());
            int written = COMPLETE;
            while (written != COMPLETE || cur.next()) {
                Storable row = (Storable)cur.get();
                while (this.evictionTracker.evictionRequired()) {
                    this.evictionTracker.evictDataPage();
                    this.memMetrics.updateEvictionRate();
                }
                if (written == COMPLETE) {
                    written = this.writeWholePages(row, statHolder);
                    continue;
                }
                AbstractDataPageIO initIo = null;
                long pageId = this.takePage(row.size() - written, row, statHolder);
                if (pageId == 0L) {
                    pageId = this.allocateDataPage(row.partition());
                    initIo = row.ioVersions().latest();
                }
                written = this.write(pageId, this.writeRowsHnd, initIo, cur, written, FAIL_I, statHolder);
                assert (written != FAIL_I);
            }
        }
        catch (RuntimeException e) {
            throw new CorruptedFreeListException("Failed to insert data rows", e);
        }
    }

    private int writeWholePages(T row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (row.link() == 0L) : row.link();
        int written = 0;
        int rowSize = row.size();
        while (rowSize - written >= this.MIN_SIZE_FOR_DATA_PAGE) {
            written = this.writeSinglePage(row, written, statHolder);
            this.memMetrics.incrementLargeEntriesPages();
        }
        return written;
    }

    private int writeSinglePage(T row, int written, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        AbstractDataPageIO initIo = null;
        long pageId = this.takePage(row.size() - written, row, statHolder);
        if (pageId == 0L) {
            pageId = this.allocateDataPage(row.partition());
            initIo = row.ioVersions().latest();
        }
        written = this.write(pageId, this.writeRowHnd, initIo, row, written, FAIL_I, statHolder);
        assert (written != FAIL_I);
        return written;
    }

    private long takePage(int size, T row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        long pageId = 0L;
        if (size < this.MIN_SIZE_FOR_DATA_PAGE) {
            for (int b = this.bucket(size, false) + 1; b < 255 && (pageId = this.takeEmptyPage(b, row.ioVersions(), statHolder)) == 0L; ++b) {
            }
        }
        if (pageId == 0L) {
            if (this.reuseList == this) {
                pageId = this.takeEmptyPage(255, row.ioVersions(), statHolder);
            } else {
                pageId = this.reuseList.takeRecycledPage();
                if (pageId != 0L) {
                    pageId = this.reuseList.initRecycledPage(pageId, (byte)1, row.ioVersions().latest());
                }
            }
        }
        if (pageId == 0L) {
            return 0L;
        }
        assert (PageIdUtils.flag(pageId) == 1) : "rowVersions=" + row.ioVersions() + ", pageId=" + PageIdUtils.toDetailString(pageId);
        return PageIdUtils.changePartitionId(pageId, row.partition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initReusedPage(T row, long reusedPageId, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        long reusedPage = this.acquirePage(reusedPageId, statHolder);
        try {
            long l;
            long reusedPageAddr = this.writeLock(reusedPageId, reusedPage);
            assert (reusedPageAddr != 0L);
            try {
                l = this.initReusedPage(reusedPageId, reusedPage, reusedPageAddr, row.partition(), (byte)1, row.ioVersions().latest());
            }
            catch (Throwable throwable) {
                this.writeUnlock(reusedPageId, reusedPage, reusedPageAddr, true);
                throw throwable;
            }
            this.writeUnlock(reusedPageId, reusedPage, reusedPageAddr, true);
            return l;
        }
        finally {
            this.releasePage(reusedPageId, reusedPage);
        }
    }

    @Override
    public boolean updateDataRow(long link, T row, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            Boolean updated = this.write(pageId, this.updateRow, row, itemId, null, statHolder);
            assert (updated != null);
            return updated;
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to update data row", t);
        }
    }

    @Override
    public <S, R> R updateDataRow(long link, PageHandler<S, R> pageHnd, S arg, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            R updRes = this.write(pageId, pageHnd, arg, itemId, null, statHolder);
            assert (updRes != null);
            return updRes;
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to update data row", t);
        }
    }

    @Override
    public void removeDataRowByLink(long link, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            LongListReuseBag bag = new LongListReuseBag();
            long nextLink = this.write(pageId, this.rmvRow, bag, itemId, FAIL_L, statHolder);
            assert (nextLink != FAIL_L);
            while (nextLink != 0L) {
                this.memMetrics.decrementLargeEntriesPages();
                itemId = PageIdUtils.itemId(nextLink);
                pageId = PageIdUtils.pageId(nextLink);
                nextLink = this.write(pageId, this.rmvRow, bag, itemId, FAIL_L, statHolder);
                assert (nextLink != FAIL_L);
            }
            this.reuseList.addForRecycle(bag);
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to remove data by link", t);
        }
    }

    @Override
    protected PagesList.Stripe[] getBucket(int bucket) {
        return this.buckets.get(bucket);
    }

    @Override
    protected boolean casBucket(int bucket, PagesList.Stripe[] exp, PagesList.Stripe[] upd) {
        boolean res = this.buckets.compareAndSet(bucket, exp, upd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("CAS bucket [list=" + this.name + ", bucket=" + bucket + ", old=" + Arrays.toString(exp) + ", new=" + Arrays.toString(upd) + ", res=" + res + ']');
        }
        return res;
    }

    @Override
    protected boolean isReuseBucket(int bucket) {
        return bucket == 255;
    }

    @Override
    protected PagesList.PagesCache getBucketCache(int bucket, boolean create) {
        PagesList.PagesCache pagesCache = this.bucketCaches.get(bucket);
        if (pagesCache == null && create && !this.bucketCaches.compareAndSet(bucket, null, pagesCache = new PagesList.PagesCache(this.pageListCacheLimit))) {
            pagesCache = this.bucketCaches.get(bucket);
        }
        return pagesCache;
    }

    public int emptyDataPages() {
        return (int)this.bucketsSize.get(255);
    }

    @Override
    public void addForRecycle(ReuseBag bag) throws IgniteCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            this.put(bag, 0L, 0L, 0L, 255, IoStatisticsHolderNoOp.INSTANCE);
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to add page for recycle", t);
        }
    }

    @Override
    public long takeRecycledPage() throws IgniteCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            return this.takeEmptyPage(255, null, IoStatisticsHolderNoOp.INSTANCE);
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to take recycled page", t);
        }
    }

    @Override
    public long initRecycledPage(long pageId, byte flag, PageIO initIO) throws IgniteCheckedException {
        return this.initRecycledPage0(pageId, flag, initIO);
    }

    @Override
    public long recycledPagesCount() throws IgniteCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            return this.storedPagesCount(255);
        }
        catch (Error | IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to count recycled pages", t);
        }
    }

    public String toString() {
        return "FreeList [name=" + this.name + ']';
    }

    private final class RemoveRowHandler
    extends PageHandler<ReuseBag, Long> {
        private final boolean maskPartId;

        RemoveRowHandler(boolean maskPartId) {
            this.maskPartId = maskPartId;
        }

        @Override
        public Long run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, ReuseBag reuseBag, int itemId, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            int newFreeSpace;
            AbstractDataPageIO io = (AbstractDataPageIO)iox;
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace >= 0) : oldFreeSpace;
            long nextLink = io.removeRow(pageAddr, itemId, AbstractFreeList.this.pageSize());
            if (AbstractFreeList.this.needWalDeltaRecord(pageId, page, walPlc)) {
                AbstractFreeList.this.wal.log(new DataPageRemoveRecord(cacheId, pageId, itemId));
            }
            if ((newFreeSpace = io.getFreeSpace(pageAddr)) > 8) {
                int oldBucket;
                boolean putIsNeeded;
                int newBucket = AbstractFreeList.this.bucket(newFreeSpace, false);
                boolean bl = putIsNeeded = oldFreeSpace <= 8;
                if (!putIsNeeded && (oldBucket = AbstractFreeList.this.bucket(oldFreeSpace, false)) != newBucket) {
                    pageId = this.maskPartId ? PageIdUtils.maskPartitionId(pageId) : pageId;
                    putIsNeeded = AbstractFreeList.this.removeDataPage(pageId, page, pageAddr, io, oldBucket, statHolder);
                }
                if (io.isEmpty(pageAddr)) {
                    AbstractFreeList.this.evictionTracker.forgetPage(pageId);
                    if (putIsNeeded) {
                        reuseBag.addFreePage(AbstractFreeList.this.recyclePage(pageId, page, pageAddr, null));
                    }
                } else if (putIsNeeded) {
                    AbstractFreeList.this.put(null, pageId, page, pageAddr, newBucket, statHolder);
                }
            }
            return nextLink;
        }
    }

    private final class WriteRowsHandler
    extends PageHandler<GridCursor<T>, Integer> {
        private WriteRowsHandler() {
        }

        @Override
        public Integer run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, GridCursor<T> cur, int written, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            AbstractDataPageIO io = (AbstractDataPageIO)iox;
            while (written != COMPLETE || !AbstractFreeList.this.evictionTracker.evictionRequired() && cur.next()) {
                Storable row = (Storable)cur.get();
                if (written == COMPLETE) {
                    written = AbstractFreeList.this.writeWholePages(row, statHolder);
                    if (written == COMPLETE) continue;
                    if (io.getFreeSpace(pageAddr) < row.size() - written) break;
                }
                written = AbstractFreeList.this.writeRowHnd.addRow(pageId, page, pageAddr, io, row, written);
                assert (written == COMPLETE);
                AbstractFreeList.this.evictionTracker.touchPage(pageId);
            }
            AbstractFreeList.this.writeRowHnd.putPage(io.getFreeSpace(pageAddr), pageId, page, pageAddr, statHolder);
            return written;
        }
    }

    private class WriteRowHandler
    extends PageHandler<T, Integer> {
        private WriteRowHandler() {
        }

        @Override
        public Integer run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, T row, int written, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            written = this.addRow(pageId, page, pageAddr, iox, row, written);
            this.putPage(((AbstractDataPageIO)iox).getFreeSpace(pageAddr), pageId, page, pageAddr, statHolder);
            return written;
        }

        protected Integer addRow(long pageId, long page, long pageAddr, PageIO iox, T row, int written) throws IgniteCheckedException {
            AbstractDataPageIO io = (AbstractDataPageIO)iox;
            int rowSize = row.size();
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace > 0) : oldFreeSpace;
            int n = written = written == 0 && oldFreeSpace >= rowSize ? this.addRowFull(pageId, page, pageAddr, io, row, rowSize) : this.addRowFragment(pageId, page, pageAddr, io, row, written, rowSize);
            if (written == rowSize) {
                AbstractFreeList.this.evictionTracker.touchPage(pageId);
            }
            return written == rowSize ? COMPLETE : written;
        }

        protected int addRowFull(long pageId, long page, long pageAddr, AbstractDataPageIO<T> io, T row, int rowSize) throws IgniteCheckedException {
            io.addRow(pageId, pageAddr, row, rowSize, AbstractFreeList.this.pageSize());
            if (AbstractFreeList.this.needWalDeltaRecord(pageId, page, null)) {
                byte[] payload = new byte[rowSize];
                DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(row.link()), AbstractFreeList.this.pageSize());
                assert (data.payloadSize() == rowSize);
                PageUtils.getBytes(pageAddr, data.offset(), payload, 0, rowSize);
                AbstractFreeList.this.wal.log(new DataPageInsertRecord(AbstractFreeList.this.grpId, pageId, payload));
            }
            return rowSize;
        }

        protected int addRowFragment(long pageId, long page, long pageAddr, AbstractDataPageIO<T> io, T row, int written, int rowSize) throws IgniteCheckedException {
            long lastLink = row.link();
            int payloadSize = io.addRowFragment(AbstractFreeList.this.pageMem, pageId, pageAddr, row, written, rowSize, AbstractFreeList.this.pageSize());
            assert (payloadSize > 0) : payloadSize;
            if (AbstractFreeList.this.needWalDeltaRecord(pageId, page, null)) {
                byte[] payload = new byte[payloadSize];
                DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(row.link()), AbstractFreeList.this.pageSize());
                PageUtils.getBytes(pageAddr, data.offset(), payload, 0, payloadSize);
                AbstractFreeList.this.wal.log(new DataPageInsertFragmentRecord(AbstractFreeList.this.grpId, pageId, payload, lastLink));
            }
            return written + payloadSize;
        }

        protected void putPage(int freeSpace, long pageId, long page, long pageAddr, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            if (freeSpace > 8) {
                int bucket = AbstractFreeList.this.bucket(freeSpace, false);
                AbstractFreeList.this.put(null, pageId, page, pageAddr, bucket, statHolder);
            }
        }
    }

    private final class UpdateRowHandler
    extends PageHandler<T, Boolean> {
        private UpdateRowHandler() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, T row, int itemId, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            AbstractDataPageIO io = (AbstractDataPageIO)iox;
            int rowSize = row.size();
            boolean updated = io.updateRow(pageAddr, itemId, AbstractFreeList.this.pageSize(), null, row, rowSize);
            AbstractFreeList.this.evictionTracker.touchPage(pageId);
            if (updated && AbstractFreeList.this.needWalDeltaRecord(pageId, page, walPlc)) {
                byte[] payload = new byte[rowSize];
                DataPagePayload data = io.readPayload(pageAddr, itemId, AbstractFreeList.this.pageSize());
                assert (data.payloadSize() == rowSize);
                PageUtils.getBytes(pageAddr, data.offset(), payload, 0, rowSize);
                AbstractFreeList.this.wal.log(new DataPageUpdateRecord(cacheId, pageId, itemId, payload));
            }
            return updated;
        }
    }
}

