/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequestHandler;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

class JdbcRequestHandlerWorker
extends GridWorker {
    private final LinkedBlockingQueue<T2<JdbcRequest, GridFutureAdapter<ClientListenerResponse>>> queue = new LinkedBlockingQueue();
    private final JdbcRequestHandler hnd;
    private final GridKernalContext ctx;
    private static final ClientListenerResponse ERR_RESPONSE = new JdbcResponse(1, "Connection closed.");

    JdbcRequestHandlerWorker(@Nullable String igniteInstanceName, IgniteLogger log, JdbcRequestHandler hnd, GridKernalContext ctx) {
        super(igniteInstanceName, "jdbc-request-handler-worker", log);
        A.notNull(hnd, "hnd");
        this.hnd = hnd;
        this.ctx = ctx;
    }

    void start() {
        new IgniteThread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
        block12: {
            T2<JdbcRequest, GridFutureAdapter<ClientListenerResponse>> req2;
            block9: while (true) {
                while (!this.isCancelled()) {
                    req2 = this.queue.take();
                    GridFutureAdapter fut = (GridFutureAdapter)req2.get2();
                    try {
                        JdbcResponse res = this.hnd.doHandle((JdbcRequest)req2.get1());
                        fut.onDone(res);
                        continue block9;
                    }
                    catch (Exception e) {
                        fut.onDone(e);
                    }
                }
                break block12;
                {
                    continue block9;
                    break;
                }
                break;
            }
            finally {
                try {
                    this.ctx.query().getIndexing().onClientDisconnect();
                }
                catch (Exception req2) {}
                req2 = this.queue.poll();
                while (req2 != null) {
                    ((GridFutureAdapter)req2.get2()).onDone(ERR_RESPONSE);
                    req2 = this.queue.poll();
                }
            }
        }
    }

    GridFutureAdapter<ClientListenerResponse> process(JdbcRequest req) {
        GridFutureAdapter<ClientListenerResponse> fut = new GridFutureAdapter<ClientListenerResponse>();
        this.queue.add(new T2(req, fut));
        return fut;
    }
}

