/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;

public class PredicateCollectionView<T>
extends GridSerializableCollection<T> {
    private static final long serialVersionUID = 0L;
    private final Collection<T> col;
    private final IgnitePredicate<? super T>[] preds;

    @SafeVarargs
    public PredicateCollectionView(Collection<T> col, IgnitePredicate<? super T> ... preds) {
        this.col = col;
        this.preds = preds;
    }

    @Override
    public boolean add(T e) {
        return GridFunc.isAll(e, this.preds) && this.col.add(e);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return F.iterator0(this.col, false, this.preds);
    }

    @Override
    public int size() {
        return F.size(this.col, this.preds);
    }

    @Override
    public boolean isEmpty() {
        return F.isEmpty(this.preds) ? this.col.isEmpty() : !this.iterator().hasNext();
    }
}

