/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.rocksdb.IteratorOptions;
import org.apache.bifromq.basekv.localengine.rocksdb.Keys;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBSnapshot;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RocksDBKVSpaceIterator
implements IKVSpaceIterator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBKVSpaceIterator.class);
    private final byte[] startKey;
    private final byte[] endKey;
    private final IteratorOptions options;
    private final AtomicReference<RocksDBItrHolder> rocksItrHolder = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CloseListener closeListener;

    public RocksDBKVSpaceIterator(RocksDBSnapshot snapshot, Boundary boundary, IteratorOptions options) {
        this(snapshot, boundary, itr -> {}, options);
    }

    public RocksDBKVSpaceIterator(RocksDBSnapshot snapshot, Boundary boundary, CloseListener closeListener, IteratorOptions options) {
        byte[] boundaryStartKey = BoundaryUtil.startKeyBytes((Boundary)boundary);
        byte[] boundaryEndKey = BoundaryUtil.endKeyBytes((Boundary)boundary);
        this.startKey = boundaryStartKey != null ? Keys.toDataKey(boundaryStartKey) : Keys.DATA_SECTION_START;
        this.endKey = boundaryEndKey != null ? Keys.toDataKey(boundaryEndKey) : Keys.DATA_SECTION_END;
        this.options = options;
        this.closeListener = closeListener;
        this.refresh(snapshot);
    }

    public ByteString key() {
        return Keys.fromDataKey(this.rocksItrHolder.get().rocksIterator.key());
    }

    public ByteString value() {
        return UnsafeByteOperations.unsafeWrap((byte[])this.rocksItrHolder.get().rocksIterator.value());
    }

    public boolean isValid() {
        return this.rocksItrHolder.get().rocksIterator.isValid();
    }

    public void next() {
        this.rocksItrHolder.get().rocksIterator.next();
    }

    public void prev() {
        this.rocksItrHolder.get().rocksIterator.prev();
    }

    public void seekToFirst() {
        this.rocksItrHolder.get().rocksIterator.seekToFirst();
    }

    public void seekToLast() {
        this.rocksItrHolder.get().rocksIterator.seekToLast();
    }

    public void seek(ByteString target) {
        this.rocksItrHolder.get().rocksIterator.seek(Keys.toDataKey(target));
    }

    public void seekForPrev(ByteString target) {
        this.rocksItrHolder.get().rocksIterator.seekForPrev(Keys.toDataKey(target));
    }

    public void refresh(RocksDBSnapshot snapshot) {
        if (this.closed.get()) {
            return;
        }
        try {
            RocksDBItrHolder rocksItrHolder = this.rocksItrHolder.get();
            if (rocksItrHolder == null) {
                this.rocksItrHolder.set(this.build(snapshot));
            } else if (rocksItrHolder.epoch == snapshot.epoch()) {
                rocksItrHolder.rocksIterator.refresh(snapshot.snapshot());
            } else {
                this.rocksItrHolder.set(this.build(snapshot));
                rocksItrHolder.close();
            }
        }
        catch (Throwable e) {
            throw new KVEngineException("Unable to refresh iterator", e);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                RocksDBItrHolder rocksItrHolder = this.rocksItrHolder.getAndSet(null);
                if (rocksItrHolder != null) {
                    rocksItrHolder.close();
                }
            }
            finally {
                this.closeListener.onClose(this);
            }
        }
    }

    private RocksDBItrHolder build(RocksDBSnapshot snapshot) {
        ReadOptions readOptions = new ReadOptions().setPinData(true).setFillCache(this.options.fillCache()).setReadaheadSize(this.options.readAheadSize()).setAutoPrefixMode(true);
        Slice lowerSlice = new Slice(this.startKey);
        readOptions.setIterateLowerBound((AbstractSlice)lowerSlice);
        Slice upperSlice = new Slice(this.endKey);
        readOptions.setIterateUpperBound((AbstractSlice)upperSlice);
        if (snapshot != null) {
            readOptions.setSnapshot(snapshot.snapshot());
        }
        RocksIterator rocksItr = snapshot.epoch().db().newIterator(snapshot.epoch().cf(), readOptions);
        return new RocksDBItrHolder(snapshot.epoch(), rocksItr, readOptions, lowerSlice, upperSlice);
    }

    static interface CloseListener {
        public void onClose(RocksDBKVSpaceIterator var1);
    }

    private static final class RocksDBItrHolder {
        final IRocksDBKVSpaceEpoch epoch;
        final RocksIterator rocksIterator;
        final ReadOptions readOptions;
        final Slice lowerSlice;
        final Slice upperSlice;
        private final AtomicBoolean closed = new AtomicBoolean();

        RocksDBItrHolder(IRocksDBKVSpaceEpoch epoch, RocksIterator rocksIterator, ReadOptions readOptions, Slice lowerSlice, Slice upperSlice) {
            this.epoch = epoch;
            this.rocksIterator = rocksIterator;
            this.readOptions = readOptions;
            this.lowerSlice = lowerSlice;
            this.upperSlice = upperSlice;
        }

        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.rocksIterator.close();
                this.readOptions.close();
                if (this.lowerSlice != null) {
                    this.lowerSlice.close();
                }
                if (this.upperSlice != null) {
                    this.upperSlice.close();
                }
            }
        }
    }
}

