/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.IWriteStatsRecorder;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVEngine;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceWriterHelper;
import org.apache.bifromq.basekv.proto.Boundary;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

class RocksDBKVSpaceWriter
implements IKVSpaceWriter {
    protected final String id;
    protected final KVSpaceOpMeters opMeters;
    protected final Logger logger;
    protected final RocksDBKVEngine<?> engine;
    protected final RocksDBKVSpaceWriterHelper helper;
    protected final IRocksDBKVSpaceEpochHandle dbHandle;
    private final IWriteStatsRecorder.IRecorder writeStatsRecorder;

    RocksDBKVSpaceWriter(String id, IRocksDBKVSpaceEpochHandle dbHandle, RocksDBKVEngine<?> engine, WriteOptions writeOptions, ISyncContext syncContext, IWriteStatsRecorder.IRecorder writeStatsRecorder, Consumer<Map<ByteString, ByteString>> afterWrite, KVSpaceOpMeters opMeters, Logger logger) {
        this(id, dbHandle, engine, syncContext, new RocksDBKVSpaceWriterHelper(dbHandle.db(), writeOptions), writeStatsRecorder, afterWrite, opMeters, logger);
    }

    private RocksDBKVSpaceWriter(String id, IRocksDBKVSpaceEpochHandle dbHandle, RocksDBKVEngine<?> engine, ISyncContext syncContext, RocksDBKVSpaceWriterHelper writerHelper, IWriteStatsRecorder.IRecorder writeStatsRecorder, Consumer<Map<ByteString, ByteString>> afterWrite, KVSpaceOpMeters opMeters, Logger logger) {
        this.id = id;
        this.opMeters = opMeters;
        this.logger = logger;
        this.dbHandle = dbHandle;
        this.engine = engine;
        this.helper = writerHelper;
        this.writeStatsRecorder = writeStatsRecorder;
        writerHelper.addMutator(syncContext.mutator());
        writerHelper.addAfterWriteCallback(dbHandle.cf(), afterWrite);
    }

    public String id() {
        return this.id;
    }

    public IKVSpaceWriter metadata(ByteString metaKey, ByteString metaValue) {
        try {
            this.helper.metadata(this.dbHandle.cf(), metaKey, metaValue);
            return this;
        }
        catch (RocksDBException e) {
            throw new KVEngineException("Put in batch failed", (Throwable)e);
        }
    }

    public IKVSpaceWriter insert(ByteString key, ByteString value) {
        try {
            this.helper.insert(this.dbHandle.cf(), key, value);
            this.writeStatsRecorder.recordInsert();
            return this;
        }
        catch (RocksDBException e) {
            throw new KVEngineException("Insert in batch failed", (Throwable)e);
        }
    }

    public IKVSpaceWriter put(ByteString key, ByteString value) {
        try {
            this.helper.put(this.dbHandle.cf(), key, value);
            this.writeStatsRecorder.recordPut();
            return this;
        }
        catch (RocksDBException e) {
            throw new KVEngineException("Put in batch failed", (Throwable)e);
        }
    }

    public IKVSpaceWriter delete(ByteString key) {
        try {
            this.helper.delete(this.dbHandle.cf(), key);
            this.writeStatsRecorder.recordDelete();
            return this;
        }
        catch (RocksDBException e) {
            throw new KVEngineException("Single delete in batch failed", (Throwable)e);
        }
    }

    public IKVSpaceWriter clear() {
        return this.clear(Boundary.getDefaultInstance());
    }

    public IKVSpaceWriter clear(Boundary boundary) {
        try {
            this.helper.clear(this.dbHandle.cf(), boundary);
            this.writeStatsRecorder.recordDeleteRange();
        }
        catch (Throwable e) {
            throw new KVEngineException("Delete range in batch failed", e);
        }
        return this;
    }

    public void done() {
        this.opMeters.batchWriteCallTimer.record(() -> {
            try {
                this.opMeters.writeBatchSizeSummary.record((double)this.helper.count());
                this.helper.done();
                this.writeStatsRecorder.stop();
            }
            catch (Throwable e) {
                this.logger.error("Write Batch commit failed", e);
                throw new KVEngineException("Batch commit failed", e);
            }
        });
    }

    public void abort() {
        this.helper.abort();
    }

    public int count() {
        return this.helper.count();
    }
}

