/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.deliverer.DeliveryCall;
import org.apache.bifromq.deliverer.IMessageDeliverer;
import org.apache.bifromq.deliverer.TopicMessagePackHolder;
import org.apache.bifromq.dist.worker.schema.cache.NormalMatching;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.distservice.DeliverError;
import org.apache.bifromq.plugin.eventcollector.distservice.Delivered;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliverExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeliverExecutor.class);
    private final IEventCollector eventCollector;
    private final IMessageDeliverer deliverer;
    private final ExecutorService executor;
    private final ConcurrentLinkedQueue<SendTask> tasks = new ConcurrentLinkedQueue();
    private final AtomicBoolean sending = new AtomicBoolean();

    public DeliverExecutor(int id, IMessageDeliverer deliverer, IEventCollector eventCollector) {
        this.eventCollector = eventCollector;
        this.deliverer = deliverer;
        this.executor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("deliver-executor-" + id)), (String)Integer.toString(id), (String)"deliver", (Tag[])new Tag[0]);
    }

    public void submit(NormalMatching route, TopicMessagePackHolder msgPackHolder, boolean inline) {
        if (inline) {
            this.send(route, msgPackHolder);
        } else {
            this.tasks.add(new SendTask(route, msgPackHolder));
            this.scheduleSend();
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    private void scheduleSend() {
        if (this.sending.compareAndSet(false, true)) {
            this.executor.submit(this::sendAll);
        }
    }

    private void sendAll() {
        SendTask task;
        while ((task = this.tasks.poll()) != null) {
            this.send(task.route, task.msgPackHolder);
        }
        this.sending.set(false);
        if (!this.tasks.isEmpty()) {
            this.scheduleSend();
        }
    }

    private void send(NormalMatching matched, TopicMessagePackHolder msgPackHolder) {
        int subBrokerId = matched.subBrokerId();
        String delivererKey = matched.delivererKey();
        MatchInfo sub = matched.matchInfo();
        DeliveryCall request = new DeliveryCall(matched.tenantId(), sub, subBrokerId, delivererKey, msgPackHolder);
        this.deliverer.schedule((Object)request).thenAccept(result -> {
            switch (result) {
                case OK: {
                    this.eventCollector.report((Event)((Delivered)ThreadLocalEventPool.getLocal(Delivered.class)).brokerId(subBrokerId).delivererKey(delivererKey).subInfo(sub).messages(msgPackHolder.messagePack));
                    break;
                }
                case NO_SUB: 
                case NO_RECEIVER: 
                case BACK_PRESSURE_REJECTED: 
                case ERROR: {
                    this.eventCollector.report((Event)((DeliverError)ThreadLocalEventPool.getLocal(DeliverError.class)).reason(result.name()).brokerId(subBrokerId).delivererKey(delivererKey).subInfo(sub).messages(msgPackHolder.messagePack));
                    break;
                }
                default: {
                    log.error("Unknown delivery result: {}", result);
                }
            }
        });
    }

    private record SendTask(NormalMatching route, TopicMessagePackHolder msgPackHolder) {
    }
}

