/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.client.UnmatchResult;
import org.apache.bifromq.dist.worker.ISubscriptionCleaner;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionCleaner
implements ISubscriptionCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionCleaner.class);
    private final ISubBrokerManager subBrokerManager;
    private final IDistClient distClient;

    SubscriptionCleaner(ISubBrokerManager subBrokerManager, IDistClient distClient) {
        this.subBrokerManager = subBrokerManager;
        this.distClient = distClient;
    }

    @Override
    public CompletableFuture<ISubscriptionCleaner.GCStats> sweep(int subBrokerId, CheckRequest request) {
        long reqId = System.nanoTime();
        return this.subBrokerManager.get(subBrokerId).check(request).thenCompose(checkReply -> {
            assert (checkReply.getCodeCount() == request.getMatchInfoCount());
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            block4: for (int i = 0; i < request.getMatchInfoCount(); ++i) {
                MatchInfo matchInfo = request.getMatchInfo(i);
                CheckReply.Code code = checkReply.getCode(i);
                switch (code) {
                    case NO_SUB: {
                        log.debug("No sub found: tenantId={}, topicFilter={}, receiverId={}, subBrokerId={}", new Object[]{request.getTenantId(), matchInfo.getMatcher().getMqttTopicFilter(), matchInfo.getReceiverId(), subBrokerId});
                        futures.add(this.distClient.removeRoute(reqId, request.getTenantId(), matchInfo.getMatcher(), matchInfo.getReceiverId(), request.getDelivererKey(), subBrokerId, matchInfo.getIncarnation()));
                        continue block4;
                    }
                    case NO_RECEIVER: {
                        log.debug("No receiverInfo found: tenantId={}, topicFilter={}, receiverId={}, subBrokerId={}", new Object[]{request.getTenantId(), matchInfo.getMatcher().getMqttTopicFilter(), matchInfo.getReceiverId(), subBrokerId});
                        futures.add(this.distClient.removeRoute(reqId, request.getTenantId(), matchInfo.getMatcher(), matchInfo.getReceiverId(), request.getDelivererKey(), subBrokerId, matchInfo.getIncarnation()));
                        continue block4;
                    }
                }
            }
            CompletableFuture<Void> all = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return all.thenApply(v -> {
                int attempts = futures.size();
                int success = 0;
                for (CompletableFuture f : futures) {
                    if (f.join() != UnmatchResult.OK) continue;
                    ++success;
                }
                return new ISubscriptionCleaner.GCStats(attempts, success);
            });
        });
    }
}

