/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.membership.proto.HostMember;
import org.apache.bifromq.basecrdt.core.api.CRDTURI;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.IMVReg;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDTUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CRDTUtil.class);
    public static final String AGENT_HOST_MAP_URI = CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)"AGENT_HOST_MAP");

    public static Optional<HostMember> getHostMember(IORMap hostListCRDT, HostEndpoint endpoint) {
        return CRDTUtil.parse(hostListCRDT.getMVReg(new ByteString[]{endpoint.toByteString()}));
    }

    public static Iterator<HostMember> iterate(IORMap hostListCRDT) {
        return Iterators.transform((Iterator)hostListCRDT.keys(), orMapkey -> CRDTUtil.parse(hostListCRDT.getMVReg(new ByteString[]{orMapkey.key()})).get());
    }

    private static Optional<HostMember> parse(IMVReg value) {
        ArrayList agentHostNodes = Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.transform((Iterator)value.read(), data -> {
            try {
                return HostMember.parseFrom(data);
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Unable to parse agent host node", (Throwable)e);
                return null;
            }
        }), Objects::nonNull));
        agentHostNodes.sort((a, b) -> b.getIncarnation() - a.getIncarnation());
        return Optional.ofNullable(agentHostNodes.isEmpty() ? null : (HostMember)agentHostNodes.get(0));
    }
}

