/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.server;

import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.baserpc.server.UnaryResponse;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.basescheduler.exception.BatcherUnavailableException;
import org.apache.bifromq.deliverer.DeliveryCall;
import org.apache.bifromq.deliverer.DeliveryCallResult;
import org.apache.bifromq.deliverer.IMessageDeliverer;
import org.apache.bifromq.deliverer.TopicMessagePackHolder;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.retain.rpc.proto.ExpireAllReply;
import org.apache.bifromq.retain.rpc.proto.ExpireAllRequest;
import org.apache.bifromq.retain.rpc.proto.MatchReply;
import org.apache.bifromq.retain.rpc.proto.MatchRequest;
import org.apache.bifromq.retain.rpc.proto.RetainReply;
import org.apache.bifromq.retain.rpc.proto.RetainRequest;
import org.apache.bifromq.retain.rpc.proto.RetainServiceGrpc;
import org.apache.bifromq.retain.server.scheduler.IMatchCallScheduler;
import org.apache.bifromq.retain.server.scheduler.IRetainCallScheduler;
import org.apache.bifromq.retain.server.scheduler.MatchRetainedRequest;
import org.apache.bifromq.retain.store.gc.IRetainStoreGCProcessor;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.type.TopicMessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetainService
extends RetainServiceGrpc.RetainServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetainService.class);
    private final IRetainStoreGCProcessor gcProcessor;
    private final IMessageDeliverer messageDeliverer;
    private final IMatchCallScheduler matchCallScheduler;
    private final IRetainCallScheduler retainCallScheduler;
    private final IRetainCallScheduler deleteCallScheduler;

    RetainService(IRetainStoreGCProcessor gcProcessor, IMessageDeliverer messageDeliverer, IMatchCallScheduler matchCallScheduler, IRetainCallScheduler retainCallScheduler, IRetainCallScheduler deleteCallScheduler) {
        this.gcProcessor = gcProcessor;
        this.messageDeliverer = messageDeliverer;
        this.matchCallScheduler = matchCallScheduler;
        this.retainCallScheduler = retainCallScheduler;
        this.deleteCallScheduler = deleteCallScheduler;
    }

    public void retain(RetainRequest request, StreamObserver<RetainReply> responseObserver) {
        log.trace("Handling retain request:\n{}", (Object)request);
        UnaryResponse.response((tenantId, metadata) -> {
            CompletableFuture completionStage = request.getMessage().getPayload().isEmpty() ? this.deleteCallScheduler.schedule(request) : this.retainCallScheduler.schedule(request);
            return completionStage.exceptionally(CompletableFutureUtil.unwrap(e -> {
                if (e instanceof BatcherUnavailableException) {
                    return RetainReply.newBuilder().setReqId(request.getReqId()).setResult(RetainReply.Result.TRY_LATER).build();
                }
                if (e instanceof BackPressureException) {
                    return RetainReply.newBuilder().setReqId(request.getReqId()).setResult(RetainReply.Result.BACK_PRESSURE_REJECTED).build();
                }
                log.debug("Retain failed", e);
                return RetainReply.newBuilder().setReqId(request.getReqId()).setResult(RetainReply.Result.ERROR).build();
            }));
        }, responseObserver);
    }

    public void match(MatchRequest request, StreamObserver<MatchReply> responseObserver) {
        log.trace("Handling match request:\n{}", (Object)request);
        UnaryResponse.response((tenantId, metadata) -> ((CompletableFuture)this.matchCallScheduler.schedule(new MatchRetainedRequest(request.getTenantId(), request.getMatchInfo().getMatcher().getMqttTopicFilter(), request.getLimit())).thenCompose(matchCallResult -> {
            if (Objects.requireNonNull(matchCallResult.result()) == MatchReply.Result.OK) {
                MatchInfo matchInfo = request.getMatchInfo();
                AtomicInteger matchedBytes = new AtomicInteger();
                List<CompletableFuture> deliveryResults = matchCallResult.retainMessages().stream().map(retainedMsg -> {
                    matchedBytes.addAndGet(retainedMsg.getTopic().length() + retainedMsg.getMessage().getPayload().size());
                    TopicMessagePack topicMessagePack = TopicMessagePack.newBuilder().setTopic(retainedMsg.getTopic()).addMessage(TopicMessagePack.PublisherPack.newBuilder().addMessage(retainedMsg.getMessage()).setPublisher(retainedMsg.getPublisher()).build()).build();
                    return this.messageDeliverer.schedule((Object)new DeliveryCall(request.getTenantId(), matchInfo, request.getBrokerId(), request.getDelivererKey(), TopicMessagePackHolder.hold((TopicMessagePack)topicMessagePack)));
                }).toList();
                ITenantMeter.get((String)request.getTenantId()).recordSummary(TenantMetric.MqttRetainMatchedBytes, (double)matchedBytes.get());
                return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])deliveryResults.toArray(CompletableFuture[]::new)).thenApply(v -> deliveryResults.stream().map(CompletableFuture::join))).thenApply(resultList -> {
                    if (resultList.allMatch(r -> r == DeliveryCallResult.OK)) {
                        return MatchReply.newBuilder().setReqId(request.getReqId()).setResult(MatchReply.Result.OK).build();
                    }
                    return MatchReply.newBuilder().setReqId(request.getReqId()).setResult(MatchReply.Result.ERROR).build();
                });
            }
            return CompletableFuture.completedFuture(MatchReply.newBuilder().setReqId(request.getReqId()).setResult(matchCallResult.result()).build());
        })).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BackPressureException) {
                return MatchReply.newBuilder().setReqId(request.getReqId()).setResult(MatchReply.Result.BACK_PRESSURE_REJECTED).build();
            }
            log.debug("Match failed", e);
            return MatchReply.newBuilder().setReqId(request.getReqId()).setResult(MatchReply.Result.ERROR).build();
        })), responseObserver);
    }

    public void expireAll(ExpireAllRequest request, StreamObserver<ExpireAllReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.gcProcessor.gc(request.getReqId(), request.getTenantId(), request.hasExpirySeconds() ? Integer.valueOf(request.getExpirySeconds()) : null, HLC.INST.getPhysical()).thenApply(result -> {
            switch (result) {
                case OK: {
                    return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setResult(ExpireAllReply.Result.OK).build();
                }
                case TRY_LATER: {
                    return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setResult(ExpireAllReply.Result.TRY_LATER).build();
                }
            }
            return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setResult(ExpireAllReply.Result.ERROR).build();
        }), responseObserver);
    }

    public void close() {
        log.debug("Stop match call scheduler");
        this.matchCallScheduler.close();
        log.debug("Stop retain call scheduler");
        this.retainCallScheduler.close();
        log.debug("Stop delete call scheduler");
        this.deleteCallScheduler.close();
        log.debug("Stop message deliverer");
        this.messageDeliverer.close();
    }
}

