/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.config.model.serde;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.apache.bifromq.starter.config.model.EngineConfig;

public class EngineConfigSerializer
extends StdSerializer<EngineConfig> {
    public EngineConfigSerializer() {
        super(EngineConfig.class);
    }

    public void serialize(EngineConfig value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        String type = value.getType();
        gen.writeStringField("type", type);
        for (Map.Entry e : value.entrySet()) {
            String k = (String)e.getKey();
            if ("type".equals(k)) continue;
            this.writeField(gen, k, e.getValue());
        }
        gen.writeEndObject();
    }

    private void writeField(JsonGenerator gen, String key, Object v) throws IOException {
        if (v == null) {
            gen.writeNullField(key);
            return;
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            gen.writeBooleanField(key, b.booleanValue());
            return;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            double d = n.doubleValue();
            long l = (long)d;
            if (Double.isFinite(d) && d == (double)l) {
                if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    gen.writeNumberField(key, (int)l);
                } else {
                    gen.writeNumberField(key, l);
                }
            } else {
                gen.writeNumberField(key, d);
            }
            return;
        }
        gen.writeObjectField(key, v);
    }
}

