/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.binder.netty4.NettyEventExecutorMetrics;
import io.netty.channel.EventLoopGroup;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.baseenv.NettyEnv;
import org.apache.bifromq.starter.config.StandaloneConfig;

public class ExecutorsModule
extends AbstractModule {
    protected void configure() {
        this.bind(EventLoopGroup.class).annotatedWith((Annotation)Names.named((String)"rpcClientEventLoop")).toProvider(RPCClientEventLoopProvider.class).in(Singleton.class);
        this.bind(ScheduledExecutorService.class).annotatedWith((Annotation)Names.named((String)"bgTaskScheduler")).toProvider(BackgroundTaskSchedulerProvider.class).in(Singleton.class);
    }

    private static class RPCClientEventLoopProvider
    implements Provider<EventLoopGroup> {
        private final StandaloneConfig config;

        @Inject
        private RPCClientEventLoopProvider(StandaloneConfig config) {
            this.config = config;
        }

        public EventLoopGroup get() {
            EventLoopGroup eventLoopGroup = NettyEnv.createEventLoopGroup((int)this.config.getRpcConfig().getClientEventLoopThreads(), (String)"rpc-client-worker-elg");
            new NettyEventExecutorMetrics((Iterable)eventLoopGroup).bindTo((MeterRegistry)Metrics.globalRegistry);
            return eventLoopGroup;
        }
    }

    private static class BackgroundTaskSchedulerProvider
    implements Provider<ScheduledExecutorService> {
        private final StandaloneConfig config;

        @Inject
        private BackgroundTaskSchedulerProvider(StandaloneConfig config) {
            this.config = config;
        }

        public ScheduledExecutorService get() {
            return ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(this.config.getBgTaskThreads(), EnvProvider.INSTANCE.newThreadFactory("bg-task-executor")), (String)"bg-task-executor", (Tag[])new Tag[0]);
        }
    }
}

