/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);
    private static final String CONF_DIR_PROP = "CONF_DIR";

    public static File loadFile(@NonNull String pathToFile) throws FileNotFoundException {
        if (pathToFile == null) {
            throw new NullPointerException("pathToFile is marked non-null but is null");
        }
        File file = new File(pathToFile);
        if (file.isAbsolute()) {
            if (file.exists() && file.isFile()) {
                return file;
            }
            throw new FileNotFoundException("File not found at absolute path: " + pathToFile);
        }
        String confDir = System.getProperty(CONF_DIR_PROP);
        if (confDir != null && (file = new File(confDir, pathToFile)).exists() && file.isFile()) {
            return file;
        }
        String userDir = System.getProperty("user.dir");
        if (userDir != null && (file = new File(userDir, pathToFile)).exists() && file.isFile()) {
            return file;
        }
        URL resource = ResourceUtil.class.getClassLoader().getResource(pathToFile);
        if (resource != null) {
            return new File(resource.getFile());
        }
        throw new FileNotFoundException("File not found: " + pathToFile);
    }

    public static File getFile(@NonNull String pathToFile) {
        if (pathToFile == null) {
            throw new NullPointerException("pathToFile is marked non-null but is null");
        }
        try {
            return ResourceUtil.loadFile(pathToFile);
        }
        catch (FileNotFoundException e) {
            log.debug("File not found: {}", (Object)pathToFile);
            return null;
        }
    }
}

