/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v3;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.mqtt.handler.MQTTConnectHandler;
import org.apache.bifromq.mqtt.handler.MQTTSessionHandler;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.DirectMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.HeapMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.ORCondition;
import org.apache.bifromq.mqtt.handler.record.GoAway;
import org.apache.bifromq.mqtt.handler.v3.MQTT3MessageUtils;
import org.apache.bifromq.mqtt.handler.v3.MQTT3PersistentSessionHandler;
import org.apache.bifromq.mqtt.handler.v3.MQTT3TransientSessionHandler;
import org.apache.bifromq.mqtt.utils.AuthUtil;
import org.apache.bifromq.mqtt.utils.IMQTTMessageSizer;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.Ok;
import org.apache.bifromq.plugin.authprovider.type.Reject;
import org.apache.bifromq.plugin.clientbalancer.IClientBalancer;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.AuthError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.IdentifierRejected;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.MalformedClientIdentifier;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.MalformedUserName;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.MalformedWillTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.NotAuthorizedClient;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.UnauthenticatedClient;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InboxTransientError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InvalidTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ProtocolViolation;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Redirect;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ResourceThrottled;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ServerBusy;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.sysprops.props.MaxMqtt3ClientIdLength;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.UserProperties;
import org.apache.bifromq.util.TopicUtil;
import org.apache.bifromq.util.UTF8Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT3ConnectHandler
extends MQTTConnectHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTT3ConnectHandler.class);
    public static final String NAME = "MQTT3ConnectHandler";
    private static final int MAX_CLIENT_ID_LEN = (Integer)MaxMqtt3ClientIdLength.INSTANCE.get();
    private IClientBalancer clientBalancer;
    private IAuthProvider authProvider;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.authProvider = ChannelAttrs.mqttSessionContext(ctx).authProvider(ctx);
        this.clientBalancer = ChannelAttrs.mqttSessionContext((ChannelHandlerContext)ctx).clientBalancer;
    }

    @Override
    protected GoAway sanityCheck(MqttConnectMessage message) {
        InetSocketAddress clientAddress = ChannelAttrs.socketAddress(this.ctx.channel());
        String requestClientId = message.payload().clientIdentifier();
        if (Strings.isNullOrEmpty((String)requestClientId) && !message.variableHeader().isCleanSession()) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED).build(), new Event[]{((IdentifierRejected)ThreadLocalEventPool.getLocal(IdentifierRejected.class)).peerAddress(clientAddress)});
        }
        if (!UTF8Util.isWellFormed((String)requestClientId, (boolean)SANITY_CHECK)) {
            return new GoAway(new Event[]{((MalformedClientIdentifier)ThreadLocalEventPool.getLocal(MalformedClientIdentifier.class)).peerAddress(clientAddress)});
        }
        if (requestClientId.length() > MAX_CLIENT_ID_LEN) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED).build(), new Event[]{((IdentifierRejected)ThreadLocalEventPool.getLocal(IdentifierRejected.class)).peerAddress(clientAddress)});
        }
        if (message.variableHeader().hasUserName() && !UTF8Util.isWellFormed((String)message.payload().userName(), (boolean)SANITY_CHECK)) {
            return new GoAway(new Event[]{((MalformedUserName)ThreadLocalEventPool.getLocal(MalformedUserName.class)).peerAddress(clientAddress)});
        }
        if (message.variableHeader().isWillFlag() && !UTF8Util.isWellFormed((String)message.payload().willTopic(), (boolean)SANITY_CHECK)) {
            return new GoAway(new Event[]{((MalformedWillTopic)ThreadLocalEventPool.getLocal(MalformedWillTopic.class)).peerAddress(clientAddress)});
        }
        return null;
    }

    @Override
    protected CompletableFuture<MQTTConnectHandler.AuthResult> authenticate(MqttConnectMessage message) {
        MQTT3AuthData authData = AuthUtil.buildMQTT3AuthData(this.ctx.channel(), message);
        return this.authProvider.auth(authData).thenApplyAsync(authResult -> {
            InetSocketAddress clientAddress = ChannelAttrs.socketAddress(this.ctx.channel());
            switch (authResult.getTypeCase()) {
                case OK: {
                    Ok ok = authResult.getOk();
                    String requestClientId = message.payload().clientIdentifier();
                    if (requestClientId.isEmpty()) {
                        requestClientId = this.ctx.channel().id().asLongText();
                    }
                    ClientInfo clientInfo = ClientInfo.newBuilder().setTenantId(ok.getTenantId()).setType("MQTT").putAllMetadata(ok.getAttrsMap()).putMetadata("ver", message.variableHeader().version() == 3 ? "3" : "4").putMetadata("userId", ok.getUserId()).putMetadata("clientId", requestClientId).putMetadata("channelId", this.ctx.channel().id().asLongText()).putMetadata("address", Optional.ofNullable(clientAddress).map(InetSocketAddress::toString).orElse("")).putMetadata("broker", ChannelAttrs.mqttSessionContext((ChannelHandlerContext)this.ctx).serverId).build();
                    return MQTTConnectHandler.AuthResult.ok(clientInfo);
                }
                case REJECT: {
                    Reject reject = authResult.getReject();
                    if (reject.hasTenantId()) {
                        ITenantMeter.get((String)reject.getTenantId()).recordCount(TenantMetric.MqttAuthFailureCount);
                    }
                    switch (reject.getCode()) {
                        case NotAuthorized: {
                            return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED).build(), new Event[]{((NotAuthorizedClient)ThreadLocalEventPool.getLocal(NotAuthorizedClient.class)).tenantId(reject.getTenantId()).userId(reject.getUserId()).clientId(authData.getClientId()).peerAddress(clientAddress)});
                        }
                        case BadPass: {
                            return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD).build(), new Event[]{((UnauthenticatedClient)ThreadLocalEventPool.getLocal(UnauthenticatedClient.class)).tenantId(reject.getTenantId()).userId(reject.getUserId()).clientId(authData.getClientId()).peerAddress(clientAddress)});
                        }
                    }
                    log.error("Unexpected error from auth provider:{}", (Object)authResult.getReject().getReason());
                    return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).cause(reject.getReason()).peerAddress(clientAddress)});
                }
            }
            return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((AuthError)((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).peerAddress(clientAddress)).cause("Unknown auth result")});
        }, (Executor)this.ctx.executor());
    }

    @Override
    protected CompletableFuture<MQTTConnectHandler.AuthResult> checkConnectPermission(MqttConnectMessage message, MQTTConnectHandler.SuccessInfo successInfo) {
        ClientInfo clientInfo = successInfo.clientInfo();
        return this.authProvider.checkPermission(clientInfo, AuthUtil.buildConnAction(UserProperties.getDefaultInstance())).thenApply(checkResult -> {
            switch (checkResult.getTypeCase()) {
                case GRANTED: {
                    return MQTTConnectHandler.AuthResult.ok(successInfo);
                }
                case DENIED: {
                    return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED).build(), new Event[]{((NotAuthorizedClient)ThreadLocalEventPool.getLocal(NotAuthorizedClient.class)).tenantId(clientInfo.getTenantId()).userId(clientInfo.getMetadataOrDefault("userId", "")).clientId(clientInfo.getMetadataOrDefault("clientId", "")).peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))});
                }
            }
            return MQTTConnectHandler.AuthResult.goAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((AuthError)ThreadLocalEventPool.getLocal(AuthError.class)).cause("Failed to check connect permission").peerAddress(ChannelAttrs.socketAddress(this.ctx.channel()))});
        });
    }

    @Override
    protected void handleMqttMessage(MqttMessage message) {
    }

    @Override
    protected GoAway onNoEnoughResources(MqttConnectMessage message, TenantResourceType resourceType, ClientInfo clientInfo) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(resourceType.name()).clientInfo(clientInfo), ((ResourceThrottled)ThreadLocalEventPool.getLocal(ResourceThrottled.class)).reason(resourceType.name()).clientInfo(clientInfo)});
    }

    @Override
    protected GoAway validate(MqttConnectMessage message, TenantSettings settings, ClientInfo clientInfo) {
        if (message.variableHeader().version() == 3 && !settings.mqtt3Enabled) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3.1 not enabled").clientInfo(clientInfo)});
        }
        if (message.variableHeader().version() == 4 && !settings.mqtt4Enabled) {
            return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3.1.1 not enabled").clientInfo(clientInfo)});
        }
        if (IMQTTMessageSizer.mqtt3().lastWillSize(message) > settings.maxLastWillSize) {
            return new GoAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Too large connect packet").clientInfo(clientInfo)});
        }
        if (message.variableHeader().isWillFlag()) {
            if (!TopicUtil.isValidTopic((String)message.payload().willTopic(), (int)settings.maxTopicLevelLength, (int)settings.maxTopicLevels, (int)settings.maxTopicLength)) {
                return new GoAway(new Event[]{((InvalidTopic)ThreadLocalEventPool.getLocal(InvalidTopic.class)).topic(message.payload().willTopic()).clientInfo(clientInfo)});
            }
            if (message.variableHeader().isWillRetain() && !settings.retainEnabled) {
                return new GoAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Retain not supported").clientInfo(clientInfo)});
            }
            if (message.variableHeader().willQos() > settings.maxQoS.getNumber()) {
                return new GoAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Will QoS not supported").clientInfo(clientInfo)});
            }
        }
        return null;
    }

    @Override
    protected GoAway needRedirect(ClientInfo clientInfo) {
        Optional redirection = this.clientBalancer.needRedirect(clientInfo);
        return redirection.map(value -> new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((Redirect)ThreadLocalEventPool.getLocal(Redirect.class)).isPermanent(value.permanentMove()).serverReference((String)value.serverReference().orElse(null)).clientInfo(clientInfo)})).orElse(null);
    }

    @Override
    protected LWT getWillMessage(MqttConnectMessage message, ClientInfo clientInfo) {
        return MQTT3MessageUtils.toWillMessage(message, clientInfo, this.sessionCtx.userPropsCustomizer);
    }

    @Override
    protected boolean isCleanStart(MqttConnectMessage message, TenantSettings settings) {
        return settings.forceTransient || message.variableHeader().isCleanSession();
    }

    @Override
    protected int getSessionExpiryInterval(MqttConnectMessage message, TenantSettings settings) {
        return this.isCleanStart(message, settings) ? 0 : settings.maxSEI;
    }

    @Override
    protected GoAway onInboxCallError(ClientInfo clientInfo, String reason) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((InboxTransientError)ThreadLocalEventPool.getLocal(InboxTransientError.class)).reason(reason).clientInfo(clientInfo)});
    }

    @Override
    protected GoAway onInboxCallRetry(ClientInfo clientInfo, String reason) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((InboxTransientError)ThreadLocalEventPool.getLocal(InboxTransientError.class)).reason(reason).clientInfo(clientInfo)});
    }

    @Override
    protected GoAway onInboxCallBusy(ClientInfo clientInfo, String reason) {
        return new GoAway((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason(reason).clientInfo(clientInfo)});
    }

    @Override
    protected final MQTTSessionHandler buildTransientSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, ITenantMeter tenantMeter, String userSessionId, int keepAliveSeconds, LWT willMessage, ClientInfo clientInfo, ChannelHandlerContext ctx) {
        return MQTT3TransientSessionHandler.builder().settings(settings).tenantMeter(tenantMeter).oomCondition(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE)).userSessionId(userSessionId).keepAliveTimeSeconds(keepAliveSeconds).clientInfo(clientInfo).willMessage(willMessage).ctx(ctx).build();
    }

    @Override
    protected final MQTTSessionHandler buildPersistentSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, ITenantMeter tenantMeter, String userSessionId, int keepAliveSeconds, int sessionExpiryInterval, InboxVersion inboxVersion, LWT noDelayLWT, ClientInfo clientInfo, ChannelHandlerContext ctx) {
        return MQTT3PersistentSessionHandler.builder().settings(settings).tenantMeter(tenantMeter).oomCondition(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE)).userSessionId(userSessionId).keepAliveTimeSeconds(keepAliveSeconds).sessionExpirySeconds(sessionExpiryInterval).clientInfo(clientInfo).inboxVersion(inboxVersion).noDelayLWT(noDelayLWT).ctx(ctx).build();
    }

    @Override
    protected MqttConnAckMessage onConnected(MqttConnectMessage connMsg, TenantSettings settings, String userSessionId, int keepAliveSeconds, int sessionExpiryInterval, boolean sessionExists, ClientInfo clientInfo, Optional<String> responseInfo, Optional<ByteString> authData, UserProperties userProperties) {
        return MqttMessageBuilders.connAck().sessionPresent(sessionExists).returnCode(MqttConnectReturnCode.CONNECTION_ACCEPTED).build();
    }

    @Override
    protected int maxPacketSize(MqttConnectMessage connMsg, TenantSettings settings) {
        return settings.maxPacketSize;
    }
}

