/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5.reason;

public enum MQTT5PubRecReasonCode {
    Success(0),
    NoMatchingSubscribers(16),
    UnspecifiedError(-128),
    ImplementationSpecificError(-125),
    NotAuthorized(-121),
    TopicNameInvalid(-112),
    PacketIdentifierInUse(-111),
    QuotaExceeded(-105),
    PayloadFormatInvalid(-103);

    private final byte value;

    private MQTT5PubRecReasonCode(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static MQTT5PubRecReasonCode valueOf(byte value) {
        return switch (value) {
            case 0 -> Success;
            case 16 -> NoMatchingSubscribers;
            case -128 -> UnspecifiedError;
            case -125 -> ImplementationSpecificError;
            case -121 -> NotAuthorized;
            case -112 -> TopicNameInvalid;
            case -111 -> PacketIdentifierInUse;
            case -105 -> QuotaExceeded;
            case -103 -> PayloadFormatInvalid;
            default -> throw new IllegalArgumentException("Invalid PubRec ReasonCode: " + value);
        };
    }
}

