/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.range.IKVLoadRecorder;

class LoadRecordableKVIterator
implements IKVIterator {
    private final IKVIterator delegate;
    private final IKVLoadRecorder recorder;

    LoadRecordableKVIterator(IKVIterator delegate, IKVLoadRecorder recorder) {
        this.delegate = delegate;
        this.recorder = recorder;
    }

    public ByteString key() {
        long start = System.nanoTime();
        ByteString result = this.delegate.key();
        this.recorder.record(result, System.nanoTime() - start);
        return result;
    }

    public ByteString value() {
        long start = System.nanoTime();
        ByteString result = this.delegate.value();
        this.recorder.record(System.nanoTime() - start);
        return result;
    }

    public boolean isValid() {
        return this.delegate.isValid();
    }

    public void next() {
        long start = System.nanoTime();
        this.delegate.next();
        this.recorder.record(System.nanoTime() - start);
    }

    public void prev() {
        long start = System.nanoTime();
        this.delegate.prev();
        this.recorder.record(System.nanoTime() - start);
    }

    public void seekToFirst() {
        long start = System.nanoTime();
        this.delegate.seekToFirst();
        this.recorder.record(System.nanoTime() - start);
    }

    public void seekToLast() {
        long start = System.nanoTime();
        this.delegate.seekToLast();
        this.recorder.record(System.nanoTime() - start);
    }

    public void seek(ByteString key) {
        long start = System.nanoTime();
        this.delegate.seek(key);
        this.recorder.record(key, System.nanoTime() - start);
    }

    public void seekForPrev(ByteString key) {
        long start = System.nanoTime();
        this.delegate.seekForPrev(key);
        this.recorder.record(key, System.nanoTime() - start);
    }

    public void close() {
        this.delegate.close();
    }
}

