/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jbpm.flow.migration.model;

import java.util.Objects;

public class ProcessDefinitionMigrationPlan {

    private String processId;
    private String processVersion;

    public ProcessDefinitionMigrationPlan() {
        // do nothing
    }

    public ProcessDefinitionMigrationPlan(String processId, String processVersion) {
        this.processId = processId;
        this.processVersion = processVersion;
    }

    public String getProcessId() {
        return processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessVersion() {
        return processVersion;
    }

    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }

    @Override
    public String toString() {
        return "Process [processId=" + processId + ", processVersion=" + processVersion + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(processId, processVersion);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ProcessDefinitionMigrationPlan other = (ProcessDefinitionMigrationPlan) obj;
        return Objects.equals(processId, other.processId) && Objects.equals(processVersion, other.processVersion);
    }

}