/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.launcher.ChildProcAppHandle;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.LauncherConnection;
import org.apache.spark.launcher.LauncherProtocol;
import org.apache.spark.launcher.NamedThreadFactory;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;

class LauncherServer
implements Closeable {
    private static final Logger LOG = Logger.getLogger(LauncherServer.class.getName());
    private static final String THREAD_NAME_FMT = "LauncherServer-%d";
    private static final long DEFAULT_CONNECT_TIMEOUT = 10000L;
    private static final SecureRandom RND = new SecureRandom();
    private static volatile LauncherServer serverInstance;
    private final AtomicLong refCount = new AtomicLong(0L);
    private final AtomicLong threadIds;
    private final ConcurrentMap<String, ChildProcAppHandle> pending;
    private final List<ServerConnection> clients;
    private final ServerSocket server;
    private final Thread serverThread;
    private final ThreadFactory factory;
    private final Timer timeoutTimer;
    private volatile boolean running;

    static synchronized ChildProcAppHandle newAppHandle() throws IOException {
        LauncherServer server = serverInstance != null ? serverInstance : new LauncherServer();
        server.ref();
        serverInstance = server;
        String secret = server.createSecret();
        while (server.pending.containsKey(secret)) {
            secret = server.createSecret();
        }
        return server.newAppHandle(secret);
    }

    static LauncherServer getServerInstance() {
        return serverInstance;
    }

    private LauncherServer() throws IOException {
        ServerSocket server = new ServerSocket();
        try {
            server.setReuseAddress(true);
            server.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
            this.clients = new ArrayList<ServerConnection>();
            this.threadIds = new AtomicLong();
            this.factory = new NamedThreadFactory(THREAD_NAME_FMT);
            this.pending = new ConcurrentHashMap<String, ChildProcAppHandle>();
            this.timeoutTimer = new Timer("LauncherServer-TimeoutTimer", true);
            this.server = server;
            this.running = true;
            this.serverThread = this.factory.newThread(new Runnable(){

                @Override
                public void run() {
                    LauncherServer.this.acceptConnections();
                }
            });
            this.serverThread.start();
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    ChildProcAppHandle newAppHandle(String secret) {
        ChildProcAppHandle handle = new ChildProcAppHandle(secret, this);
        ChildProcAppHandle existing = this.pending.putIfAbsent(secret, handle);
        CommandBuilderUtils.checkState(existing == null, "Multiple handles with the same secret.", new Object[0]);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LauncherServer launcherServer = this;
        synchronized (launcherServer) {
            if (this.running) {
                this.running = false;
                this.timeoutTimer.cancel();
                this.server.close();
                List<ServerConnection> list = this.clients;
                synchronized (list) {
                    ArrayList<ServerConnection> copy = new ArrayList<ServerConnection>(this.clients);
                    this.clients.clear();
                    for (ServerConnection client : copy) {
                        client.close();
                    }
                }
            }
        }
        if (this.serverThread != null) {
            try {
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void ref() {
        this.refCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unref() {
        Class<LauncherServer> clazz = LauncherServer.class;
        synchronized (LauncherServer.class) {
            if (this.refCount.decrementAndGet() == 0L) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    serverInstance = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    int getPort() {
        return this.server.getLocalPort();
    }

    void unregister(ChildProcAppHandle handle) {
        this.pending.remove(handle.getSecret());
        this.unref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void acceptConnections() {
        try {
            while (this.running) {
                final Socket client = this.server.accept();
                TimerTask timeout = new TimerTask(){

                    @Override
                    public void run() {
                        LOG.warning("Timed out waiting for hello message from client.");
                        try {
                            client.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                ServerConnection clientConnection = new ServerConnection(client, timeout);
                Thread clientThread = this.factory.newThread(clientConnection);
                TimerTask timerTask = timeout;
                synchronized (timerTask) {
                    clientThread.start();
                    List<ServerConnection> list = this.clients;
                    synchronized (list) {
                        this.clients.add(clientConnection);
                    }
                    long timeoutMs = this.getConnectionTimeout();
                    if (timeoutMs > 0L) {
                        this.timeoutTimer.schedule(timeout, this.getConnectionTimeout());
                    } else {
                        timeout.run();
                    }
                }
            }
            return;
        }
        catch (IOException ioe) {
            if (!this.running) return;
            LOG.log(Level.SEVERE, "Error in accept loop.", ioe);
        }
    }

    private long getConnectionTimeout() {
        String value = SparkLauncher.launcherConfig.get("spark.launcher.childConectionTimeout");
        return value != null ? Long.parseLong(value) : 10000L;
    }

    private String createSecret() {
        byte[] secret = new byte[128];
        RND.nextBytes(secret);
        StringBuilder sb = new StringBuilder();
        for (int n : secret) {
            int ival;
            int n2 = ival = n >= 0 ? n : 127 - n;
            if (ival < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(ival));
        }
        return sb.toString();
    }

    private class ServerConnection
    extends LauncherConnection {
        private TimerTask timeout;
        private ChildProcAppHandle handle;

        ServerConnection(Socket socket, TimerTask timeout) throws IOException {
            super(socket);
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handle(LauncherProtocol.Message msg) throws IOException {
            block11: {
                try {
                    if (msg instanceof LauncherProtocol.Hello) {
                        this.timeout.cancel();
                        this.timeout = null;
                        LauncherProtocol.Hello hello = (LauncherProtocol.Hello)msg;
                        ChildProcAppHandle handle = (ChildProcAppHandle)LauncherServer.this.pending.remove(hello.secret);
                        if (handle != null) {
                            handle.setState(SparkAppHandle.State.CONNECTED);
                            handle.setConnection(this);
                            this.handle = handle;
                            break block11;
                        }
                        throw new IllegalArgumentException("Received Hello for unknown client.");
                    }
                    if (this.handle == null) {
                        throw new IllegalArgumentException("Expected hello, got: " + msg != null ? msg.getClass().getName() : null);
                    }
                    if (msg instanceof LauncherProtocol.SetAppId) {
                        LauncherProtocol.SetAppId set = (LauncherProtocol.SetAppId)msg;
                        this.handle.setAppId(set.appId);
                        break block11;
                    }
                    if (msg instanceof LauncherProtocol.SetState) {
                        this.handle.setState(((LauncherProtocol.SetState)msg).state);
                        break block11;
                    }
                    throw new IllegalArgumentException("Invalid message: " + msg != null ? msg.getClass().getName() : null);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Error handling message from client.", e);
                    if (this.timeout != null) {
                        this.timeout.cancel();
                    }
                    this.close();
                }
                finally {
                    LauncherServer.this.timeoutTimer.purge();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            List list = LauncherServer.this.clients;
            synchronized (list) {
                LauncherServer.this.clients.remove(this);
            }
            super.close();
            if (this.handle != null) {
                this.handle.disconnect();
            }
        }
    }
}

