/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.client.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.livy.annotations.Private;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Private
public abstract class ClientConf<T extends ClientConf>
implements Iterable<Map.Entry<String, String>> {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientConf.class);
    private static final Map<String, TimeUnit> TIME_SUFFIXES;
    public static final boolean TEST_MODE;
    protected final ConcurrentMap<String, String> config = new ConcurrentHashMap<String, String>();
    private volatile Map<String, ConfPair> altToNewKeyMap = null;

    protected ClientConf(Properties config) {
        if (config != null) {
            for (String key : config.stringPropertyNames()) {
                this.logDeprecationWarning(key);
                this.config.put(key, config.getProperty(key));
            }
        }
    }

    public String get(String key) {
        String val = (String)this.config.get(key);
        if (val != null) {
            return val;
        }
        DeprecatedConf depConf = this.getConfigsWithAlternatives().get(key);
        if (depConf != null) {
            return (String)this.config.get(depConf.key());
        }
        return val;
    }

    public T set(String key, String value) {
        this.logDeprecationWarning(key);
        this.config.put(key, value);
        return (T)this;
    }

    public T setIfMissing(String key, String value) {
        if (this.config.putIfAbsent(key, value) == null) {
            this.logDeprecationWarning(key);
        }
        return (T)this;
    }

    public T setAll(ClientConf<?> other) {
        for (Map.Entry<String, String> e : other) {
            this.set(e.getKey(), e.getValue());
        }
        return (T)this;
    }

    public String get(ConfEntry e) {
        String value = this.get(e, String.class);
        return (String)(value != null ? value : e.dflt());
    }

    public boolean getBoolean(ConfEntry e) {
        String val = this.get(e, Boolean.class);
        if (val != null) {
            return Boolean.parseBoolean(val);
        }
        return (Boolean)e.dflt();
    }

    public int getInt(ConfEntry e) {
        String val = this.get(e, Integer.class);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return (Integer)e.dflt();
    }

    public long getLong(ConfEntry e) {
        String val = this.get(e, Long.class);
        if (val != null) {
            return Long.parseLong(val);
        }
        return (Long)e.dflt();
    }

    public long getTimeAsMs(ConfEntry e) {
        String time = this.get(e, String.class);
        if (time == null) {
            ClientConf.check(e.dflt() != null, "ConfEntry %s doesn't have a default value, cannot convert to time value.", e.key());
            time = (String)e.dflt();
        }
        return ClientConf.getTimeAsMs(time);
    }

    public static long getTimeAsMs(String time) {
        ClientConf.check(time != null && !time.trim().isEmpty(), "Invalid time string: %s", time);
        Matcher m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(time.trim().toLowerCase());
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid time string: " + time);
        }
        long val = Long.parseLong(m.group(1));
        String suffix = m.group(2);
        if (suffix != null && !TIME_SUFFIXES.containsKey(suffix)) {
            throw new IllegalArgumentException("Invalid suffix: \"" + suffix + "\"");
        }
        if (val < 0L) {
            throw new IllegalArgumentException("Invalid value: " + val);
        }
        return TimeUnit.MILLISECONDS.convert(val, suffix != null ? TIME_SUFFIXES.get(suffix) : TimeUnit.MILLISECONDS);
    }

    public T set(ConfEntry e, Object value) {
        ClientConf.check(this.typesMatch(value, e.dflt()), "Value doesn't match configuration entry type for %s.", e.key());
        if (value == null) {
            this.config.remove(e.key());
        } else {
            this.logDeprecationWarning(e.key());
            this.config.put(e.key(), value.toString());
        }
        return (T)this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.config.entrySet().iterator();
    }

    private String get(ConfEntry e, Class<?> requestedType) {
        ClientConf.check(this.getType(e.dflt()).equals(requestedType), "Invalid type conversion requested for %s.", e.key());
        return this.get(e.key());
    }

    private boolean typesMatch(Object test, Object expected) {
        return test == null || this.getType(test).equals(this.getType(expected));
    }

    private Class<?> getType(Object o) {
        return o != null ? o.getClass() : String.class;
    }

    private static void check(boolean test, String message, Object ... args) {
        if (!test) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    private void logDeprecationWarning(String key) {
        ConfPair altConf = this.allAlternativeKeys().get(key);
        if (altConf != null) {
            LOG.warn("The configuration key " + key + " has been deprecated as of Livy " + altConf.depConf.version() + " and may be removed in the future. Please use the new key " + altConf.newKey + " instead.");
            return;
        }
        DeprecatedConf depConfs = this.getDeprecatedConfigs().get(key);
        if (depConfs != null) {
            LOG.warn("The configuration key " + depConfs.key() + " has been deprecated as of Livy " + depConfs.version() + " and may be removed in the future. " + depConfs.deprecationMessage());
        }
    }

    protected abstract Map<String, DeprecatedConf> getConfigsWithAlternatives();

    protected abstract Map<String, DeprecatedConf> getDeprecatedConfigs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ConfPair> allAlternativeKeys() {
        if (this.altToNewKeyMap == null) {
            ClientConf clientConf = this;
            synchronized (clientConf) {
                if (this.altToNewKeyMap == null) {
                    HashMap<String, ConfPair> configs = new HashMap<String, ConfPair>();
                    for (String e : this.getConfigsWithAlternatives().keySet()) {
                        DeprecatedConf depConf = this.getConfigsWithAlternatives().get(e);
                        configs.put(depConf.key(), new ConfPair(e, depConf));
                    }
                    this.altToNewKeyMap = Collections.unmodifiableMap(configs);
                }
            }
        }
        return this.altToNewKeyMap;
    }

    static {
        TEST_MODE = Boolean.parseBoolean(System.getenv("LIVY_TEST"));
        TIME_SUFFIXES = new HashMap<String, TimeUnit>();
        TIME_SUFFIXES.put("us", TimeUnit.MICROSECONDS);
        TIME_SUFFIXES.put("ms", TimeUnit.MILLISECONDS);
        TIME_SUFFIXES.put("s", TimeUnit.SECONDS);
        TIME_SUFFIXES.put("m", TimeUnit.MINUTES);
        TIME_SUFFIXES.put("min", TimeUnit.MINUTES);
        TIME_SUFFIXES.put("h", TimeUnit.HOURS);
        TIME_SUFFIXES.put("d", TimeUnit.DAYS);
    }

    public static interface DeprecatedConf {
        public String key();

        public String version();

        public String deprecationMessage();
    }

    private static class ConfPair {
        final String newKey;
        final DeprecatedConf depConf;

        ConfPair(String key, DeprecatedConf conf) {
            this.newKey = key;
            this.depConf = conf;
        }
    }

    public static interface ConfEntry {
        public String key();

        public Object dflt();
    }
}

