/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.xds.ClusterSpecifierPlugin;
import io.grpc.xds.RouteLookupServiceClusterSpecifierPlugin;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class ClusterSpecifierPluginRegistry {
    private static ClusterSpecifierPluginRegistry instance;
    private final Map<String, ClusterSpecifierPlugin> supportedPlugins = new HashMap<String, ClusterSpecifierPlugin>();

    private ClusterSpecifierPluginRegistry() {
    }

    static synchronized ClusterSpecifierPluginRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = ClusterSpecifierPluginRegistry.newRegistry().register(RouteLookupServiceClusterSpecifierPlugin.INSTANCE);
        }
        return instance;
    }

    @VisibleForTesting
    static ClusterSpecifierPluginRegistry newRegistry() {
        return new ClusterSpecifierPluginRegistry();
    }

    @VisibleForTesting
    ClusterSpecifierPluginRegistry register(ClusterSpecifierPlugin ... plugins) {
        for (ClusterSpecifierPlugin plugin : plugins) {
            for (String typeUrl : plugin.typeUrls()) {
                this.supportedPlugins.put(typeUrl, plugin);
            }
        }
        return this;
    }

    @Nullable
    ClusterSpecifierPlugin get(String typeUrl) {
        return this.supportedPlugins.get(typeUrl);
    }
}

