/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.validation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.service.catalog.validation.StorageTypeFileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergPropertiesValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergPropertiesValidation.class);

    public static void validateIcebergProperties(@Nonnull CallContext callContext, @Nonnull Map<String, String> properties) {
        IcebergPropertiesValidation.determineFileIOClassName(callContext, properties, null);
    }

    public static String determineFileIOClassName(@Nonnull CallContext callContext, @Nonnull Map<String, String> properties, @Nullable PolarisStorageConfigurationInfo storageConfigurationInfo) {
        PolarisCallContext ctx = callContext.getPolarisCallContext();
        PolarisConfigurationStore configStore = ctx.getConfigurationStore();
        RealmContext realmContext = callContext.getRealmContext();
        String ioImpl = properties.get("io-impl");
        if (ioImpl != null) {
            if (!((Boolean)configStore.getConfiguration(realmContext, (PolarisConfiguration)FeatureConfiguration.ALLOW_SPECIFYING_FILE_IO_IMPL)).booleanValue()) {
                throw new ValidationException("Cannot set property '%s' to '%s' for this catalog.", new Object[]{"io-impl", ioImpl});
            }
            LOGGER.debug("Allowing overriding ioImplClassName to {} for storageConfiguration {}", (Object)ioImpl, (Object)storageConfigurationInfo);
        } else if (storageConfigurationInfo != null) {
            ioImpl = storageConfigurationInfo.getFileIoImplClassName();
            LOGGER.debug("Resolved ioImplClassName {} from storageConfiguration {}", (Object)ioImpl, (Object)storageConfigurationInfo);
        }
        if (ioImpl != null) {
            StorageTypeFileIO storageType = StorageTypeFileIO.fromFileIoImplementation(ioImpl);
            if (storageType.validateAllowedStorageType() && !((List)configStore.getConfiguration(realmContext, (PolarisConfiguration)FeatureConfiguration.SUPPORTED_CATALOG_STORAGE_TYPES)).contains(storageType.name())) {
                throw new ValidationException("File IO implementation '%s', as storage type '%s' is not supported", new Object[]{ioImpl, storageType});
            }
            if (!storageType.safe() && !((Boolean)configStore.getConfiguration(realmContext, (PolarisConfiguration)FeatureConfiguration.ALLOW_INSECURE_STORAGE_TYPES)).booleanValue()) {
                throw new ValidationException("File IO implementation '%s' (storage type '%s') is considered insecure and must not be used", new Object[]{ioImpl, storageType});
            }
        }
        return ioImpl;
    }

    public static boolean safeStorageType(String name) {
        return StorageTypeFileIO.valueOf(name).safe();
    }
}

