/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.BulkheadConfig;
import io.smallrye.faulttolerance.basicconfig.BulkheadConfigImpl;
import io.smallrye.faulttolerance.basicconfig.BulkheadNoConfigImpl;
import io.smallrye.faulttolerance.basicconfig.CircuitBreakerConfig;
import io.smallrye.faulttolerance.basicconfig.CircuitBreakerConfigImpl;
import io.smallrye.faulttolerance.basicconfig.CircuitBreakerNoConfigImpl;
import io.smallrye.faulttolerance.basicconfig.ExponentialBackoffConfig;
import io.smallrye.faulttolerance.basicconfig.ExponentialBackoffConfigImpl;
import io.smallrye.faulttolerance.basicconfig.ExponentialBackoffNoConfigImpl;
import io.smallrye.faulttolerance.basicconfig.FibonacciBackoffConfig;
import io.smallrye.faulttolerance.basicconfig.FibonacciBackoffConfigImpl;
import io.smallrye.faulttolerance.basicconfig.FibonacciBackoffNoConfigImpl;
import io.smallrye.faulttolerance.basicconfig.RateLimitConfig;
import io.smallrye.faulttolerance.basicconfig.RateLimitConfigImpl;
import io.smallrye.faulttolerance.basicconfig.RateLimitNoConfigImpl;
import io.smallrye.faulttolerance.basicconfig.RetryConfig;
import io.smallrye.faulttolerance.basicconfig.RetryConfigImpl;
import io.smallrye.faulttolerance.basicconfig.RetryNoConfigImpl;
import io.smallrye.faulttolerance.basicconfig.TimeoutConfig;
import io.smallrye.faulttolerance.basicconfig.TimeoutConfigImpl;
import io.smallrye.faulttolerance.basicconfig.TimeoutNoConfigImpl;
import io.smallrye.faulttolerance.core.util.Durations;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class BasicFaultToleranceOperation {
    protected final String description;
    protected final BulkheadConfig bulkhead;
    protected final CircuitBreakerConfig circuitBreaker;
    protected final RateLimitConfig rateLimit;
    protected final RetryConfig retry;
    protected final TimeoutConfig timeout;
    protected final ExponentialBackoffConfig exponentialBackoff;
    protected final FibonacciBackoffConfig fibonacciBackoff;

    public BasicFaultToleranceOperation(FaultToleranceMethod method) {
        Preconditions.checkNotNull((Object)method, (String)"Method must be set");
        this.description = method.method.toString();
        this.bulkhead = BulkheadConfigImpl.create(method);
        this.circuitBreaker = CircuitBreakerConfigImpl.create(method);
        this.rateLimit = RateLimitConfigImpl.create(method);
        this.retry = RetryConfigImpl.create(method);
        this.timeout = TimeoutConfigImpl.create(method);
        this.exponentialBackoff = ExponentialBackoffConfigImpl.create(method);
        this.fibonacciBackoff = FibonacciBackoffConfigImpl.create(method);
    }

    public BasicFaultToleranceOperation(String id, Supplier<Bulkhead> bulkhead, Supplier<CircuitBreaker> circuitBreaker, Supplier<RateLimit> rateLimit, Supplier<Retry> retry, Supplier<Timeout> timeout, Supplier<ExponentialBackoff> exponentialBackoff, Supplier<FibonacciBackoff> fibonacciBackoff) {
        String string = this.description = id != null ? id : "<unknown>";
        if (id != null) {
            this.bulkhead = BulkheadConfigImpl.create(id, bulkhead);
            this.circuitBreaker = CircuitBreakerConfigImpl.create(id, circuitBreaker);
            this.rateLimit = RateLimitConfigImpl.create(id, rateLimit);
            this.retry = RetryConfigImpl.create(id, retry);
            this.timeout = TimeoutConfigImpl.create(id, timeout);
            this.exponentialBackoff = ExponentialBackoffConfigImpl.create(id, exponentialBackoff);
            this.fibonacciBackoff = FibonacciBackoffConfigImpl.create(id, fibonacciBackoff);
        } else {
            this.bulkhead = BulkheadNoConfigImpl.create(bulkhead);
            this.circuitBreaker = CircuitBreakerNoConfigImpl.create(circuitBreaker);
            this.rateLimit = RateLimitNoConfigImpl.create(rateLimit);
            this.retry = RetryNoConfigImpl.create(retry);
            this.timeout = TimeoutNoConfigImpl.create(timeout);
            this.exponentialBackoff = ExponentialBackoffNoConfigImpl.create(exponentialBackoff);
            this.fibonacciBackoff = FibonacciBackoffNoConfigImpl.create(fibonacciBackoff);
        }
    }

    public boolean hasBulkhead() {
        return this.bulkhead != null;
    }

    public Bulkhead getBulkhead() {
        return this.bulkhead;
    }

    public boolean hasCircuitBreaker() {
        return this.circuitBreaker != null;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public boolean hasRateLimit() {
        return this.rateLimit != null;
    }

    public RateLimit getRateLimit() {
        return this.rateLimit;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public boolean hasExponentialBackoff() {
        return this.exponentialBackoff != null;
    }

    public ExponentialBackoff getExponentialBackoff() {
        return this.exponentialBackoff;
    }

    public boolean hasFibonacciBackoff() {
        return this.fibonacciBackoff != null;
    }

    public FibonacciBackoff getFibonacciBackoff() {
        return this.fibonacciBackoff;
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (FaultToleranceDefinitionException e) {
            return false;
        }
    }

    public void validate() {
        if (this.bulkhead != null) {
            this.bulkhead.validate();
        }
        if (this.circuitBreaker != null) {
            this.circuitBreaker.validate();
        }
        if (this.rateLimit != null) {
            this.rateLimit.validate();
        }
        if (this.retry != null) {
            this.retry.validate();
        }
        if (this.timeout != null) {
            this.timeout.validate();
        }
        this.validateRetryBackoff();
    }

    private void validateRetryBackoff() {
        long retryMaxDuration;
        HashSet<Class> backoffAnnotations = new HashSet<Class>();
        for (Config cfg : this.getBackoffConfigs()) {
            if (cfg == null) continue;
            cfg.validate();
            if (this.retry == null) {
                throw cfg.fail("missing @Retry");
            }
            backoffAnnotations.add(cfg.annotationType());
        }
        if (backoffAnnotations.size() > 1) {
            throw new FaultToleranceDefinitionException("More than one backoff defined for " + this.description + ": " + String.valueOf(backoffAnnotations));
        }
        if (this.retry != null && (retryMaxDuration = Durations.timeInMillis((long)this.retry.maxDuration(), (ChronoUnit)this.retry.durationUnit())) > 0L) {
            long maxDelay;
            if (this.exponentialBackoff != null && retryMaxDuration <= (maxDelay = Durations.timeInMillis((long)this.exponentialBackoff.maxDelay(), (ChronoUnit)this.exponentialBackoff.maxDelayUnit()))) {
                throw this.exponentialBackoff.fail("maxDelay", "should not be greated than @Retry.maxDuration");
            }
            if (this.fibonacciBackoff != null && retryMaxDuration <= (maxDelay = Durations.timeInMillis((long)this.fibonacciBackoff.maxDelay(), (ChronoUnit)this.fibonacciBackoff.maxDelayUnit()))) {
                throw this.fibonacciBackoff.fail("maxDelay", "should not be greater than @Retry.maxDuration");
            }
        }
    }

    protected List<Config> getBackoffConfigs() {
        return Arrays.asList(this.exponentialBackoff, this.fibonacciBackoff);
    }

    public void materialize() {
        if (this.bulkhead != null) {
            this.bulkhead.materialize();
        }
        if (this.circuitBreaker != null) {
            this.circuitBreaker.materialize();
        }
        if (this.rateLimit != null) {
            this.rateLimit.materialize();
        }
        if (this.retry != null) {
            this.retry.materialize();
        }
        if (this.timeout != null) {
            this.timeout.materialize();
        }
        if (this.exponentialBackoff != null) {
            this.exponentialBackoff.materialize();
        }
        if (this.fibonacciBackoff != null) {
            this.fibonacciBackoff.materialize();
        }
    }

    public String toString() {
        return "BasicFaultToleranceOperation[" + this.description + "]";
    }
}

