/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.apache.iceberg.TableMetadata;

public class TableUpdateNotification {
    private String tableName;
    private Long timestamp;
    private String tableUuid;
    private String metadataLocation;
    private TableMetadata metadata;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="table-name")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="table-uuid")
    public String getTableUuid() {
        return this.tableUuid;
    }

    public void setTableUuid(String tableUuid) {
        this.tableUuid = tableUuid;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="metadata-location")
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    public void setMetadataLocation(String metadataLocation) {
        this.metadataLocation = metadataLocation;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="metadata")
    public TableMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(TableMetadata metadata) {
        this.metadata = metadata;
    }

    public TableUpdateNotification() {
    }

    public TableUpdateNotification(String tableName, Long timestamp, String tableUuid, String metadataLocation, TableMetadata metadata) {
        this.tableName = tableName;
        this.timestamp = timestamp;
        this.tableUuid = tableUuid;
        this.metadataLocation = metadataLocation;
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableUpdateNotification)) {
            return false;
        }
        TableUpdateNotification tableUpdateNotification = (TableUpdateNotification)o;
        return Objects.equals(this.tableName, tableUpdateNotification.tableName) && Objects.equals(this.timestamp, tableUpdateNotification.timestamp) && Objects.equals(this.tableUuid, tableUpdateNotification.tableUuid) && Objects.equals(this.metadataLocation, tableUpdateNotification.metadataLocation) && Objects.equals(this.metadata, tableUpdateNotification.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.timestamp, this.tableUuid, this.metadataLocation, this.metadata);
    }

    public String toString() {
        return "class TableUpdateNotification {\n    tableName: " + TableUpdateNotification.toIndentedString(this.tableName) + "\n    timestamp: " + TableUpdateNotification.toIndentedString(this.timestamp) + "\n    tableUuid: " + TableUpdateNotification.toIndentedString(this.tableUuid) + "\n    metadataLocation: " + TableUpdateNotification.toIndentedString(this.metadataLocation) + "\n    metadata: " + TableUpdateNotification.toIndentedString(this.metadata) + "\n}";
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String tableName;
        private Long timestamp;
        private String tableUuid;
        private String metadataLocation;
        private TableMetadata metadata;

        private Builder() {
        }

        public final Builder tableName(String tableName) {
            if (tableName == null) {
                throw new IllegalArgumentException("Null table name supplied");
            }
            this.tableName = tableName;
            return this;
        }

        public final Builder timestamp(Long timestamp) {
            if (timestamp == null) {
                throw new IllegalArgumentException("timestamp can't be null");
            }
            this.timestamp = timestamp;
            return this;
        }

        public final Builder metadataLocation(String metadataLocation) {
            if (metadataLocation == null) {
                throw new IllegalArgumentException("metadataLocation can't be null");
            }
            this.metadataLocation = metadataLocation;
            return this;
        }

        public final Builder metadata(TableMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder tableUuid(String tableUuid) {
            if (tableUuid == null) {
                throw new IllegalArgumentException("timestamp can't be null");
            }
            this.tableUuid = tableUuid;
            return this;
        }

        public TableUpdateNotification build() {
            return new TableUpdateNotification(this.tableName, this.timestamp, this.tableUuid, this.metadataLocation, this.metadata);
        }
    }
}

