/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.rds.runtime;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.rds.runtime.RdsConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.RdsAsyncClientBuilder;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.RdsClientBuilder;

@Recorder
public class RdsRecorder
extends AmazonClientRecorder {
    final RuntimeValue<RdsConfig> config;

    public RdsRecorder(RuntimeValue<RdsConfig> config) {
        this.config = config;
    }

    public RuntimeValue<? extends HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return this.config;
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return ((RdsConfig)this.config.getValue()).asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return ((RdsConfig)this.config.getValue()).syncClient();
    }

    public AwsSyncClientBuilder<?, ?> getSyncClientBuilder() {
        RdsClientBuilder builder = RdsClient.builder();
        return builder;
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        RdsAsyncClientBuilder builder = RdsAsyncClient.builder();
        return builder;
    }
}

