/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.policy;

import jakarta.annotation.Nonnull;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.service.types.PolicyAttachmentTarget;

public class PolicyCatalogUtils {
    public static PolarisResolvedPathWrapper getResolvedPathWrapper(@Nonnull PolarisResolutionManifest resolutionManifest, @Nonnull PolicyAttachmentTarget target) {
        return switch (target.getType()) {
            case PolicyAttachmentTarget.TypeEnum.CATALOG -> resolutionManifest.getResolvedReferenceCatalogEntity();
            case PolicyAttachmentTarget.TypeEnum.NAMESPACE -> {
                Namespace namespace = Namespace.of((String[])target.getPath().toArray(new String[0]));
                PolarisResolvedPathWrapper resolvedTargetEntity = resolutionManifest.getResolvedPath((Object)namespace);
                if (resolvedTargetEntity == null) {
                    throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
                }
                yield resolvedTargetEntity;
            }
            case PolicyAttachmentTarget.TypeEnum.TABLE_LIKE -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])target.getPath().toArray(new String[0]));
                PolarisResolvedPathWrapper resolvedTableEntity = resolutionManifest.getResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
                if (resolvedTableEntity == null) {
                    throw new NoSuchTableException("Iceberg Table does not exist: %s", new Object[]{tableIdentifier});
                }
                yield resolvedTableEntity;
            }
            default -> throw new IllegalArgumentException("Unsupported target type: " + String.valueOf(target.getType()));
        };
    }
}

