/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer.tsmiterator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.write.writer.tsmiterator.DiskTSMIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSMIterator {
    private static final Logger LOG = LoggerFactory.getLogger(TSMIterator.class);
    protected List<Pair<Path, List<IChunkMetadata>>> sortedChunkMetadataList;
    protected Iterator<Pair<Path, List<IChunkMetadata>>> iterator;

    protected TSMIterator(List<ChunkGroupMetadata> chunkGroupMetadataList) {
        this.sortedChunkMetadataList = TSMIterator.sortChunkMetadata(chunkGroupMetadataList, null, null);
        this.iterator = this.sortedChunkMetadataList.iterator();
    }

    public static TSMIterator getTSMIteratorInMemory(List<ChunkGroupMetadata> chunkGroupMetadataList) {
        return new TSMIterator(chunkGroupMetadataList);
    }

    public static TSMIterator getTSMIteratorInDisk(File cmtFile, List<ChunkGroupMetadata> chunkGroupMetadataList, LinkedList<Long> serializePos) throws IOException {
        return new DiskTSMIterator(cmtFile, chunkGroupMetadataList, serializePos);
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Pair<Path, TimeseriesMetadata> next() throws IOException {
        Pair<Path, List<IChunkMetadata>> nextPair = this.iterator.next();
        return new Pair<Path, TimeseriesMetadata>((Path)nextPair.left, TSMIterator.constructOneTimeseriesMetadata(((Path)nextPair.left).getMeasurement(), (List)nextPair.right));
    }

    public static TimeseriesMetadata constructOneTimeseriesMetadata(String measurementId, List<IChunkMetadata> chunkMetadataList) throws IOException {
        PublicBAOS publicBAOS = new PublicBAOS();
        TSDataType dataType = chunkMetadataList.get(chunkMetadataList.size() - 1).getDataType();
        Statistics<Serializable> seriesStatistics = Statistics.getStatsByType(dataType);
        int chunkMetadataListLength = 0;
        boolean serializeStatistic = chunkMetadataList.size() > 1;
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            if (!chunkMetadata.getDataType().equals((Object)dataType)) continue;
            chunkMetadataListLength += chunkMetadata.serializeTo(publicBAOS, serializeStatistic);
            seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
        }
        TimeseriesMetadata timeseriesMetadata = new TimeseriesMetadata((byte)((serializeStatistic ? (byte)1 : 0) | chunkMetadataList.get(0).getMask()), chunkMetadataListLength, measurementId, dataType, seriesStatistics, publicBAOS);
        return timeseriesMetadata;
    }

    public static List<Pair<Path, List<IChunkMetadata>>> sortChunkMetadata(List<ChunkGroupMetadata> chunkGroupMetadataList, String currentDevice, List<ChunkMetadata> chunkMetadataList) {
        TreeMap<String, Map> chunkMetadataMap = new TreeMap<String, Map>();
        LinkedList<Pair<Path, List<IChunkMetadata>>> sortedChunkMetadataList = new LinkedList<Pair<Path, List<IChunkMetadata>>>();
        for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
            chunkMetadataMap.computeIfAbsent(chunkGroupMetadata.getDevice(), x -> new TreeMap());
            for (IChunkMetadata iChunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                ((Map)chunkMetadataMap.get(chunkGroupMetadata.getDevice())).computeIfAbsent(new Path(chunkGroupMetadata.getDevice(), iChunkMetadata.getMeasurementUid()), x -> new ArrayList()).add(iChunkMetadata);
            }
        }
        if (currentDevice != null) {
            for (IChunkMetadata iChunkMetadata : chunkMetadataList) {
                chunkMetadataMap.computeIfAbsent(currentDevice, x -> new TreeMap()).computeIfAbsent(new Path(currentDevice, iChunkMetadata.getMeasurementUid()), x -> new ArrayList()).add(iChunkMetadata);
            }
        }
        for (Map.Entry entry : chunkMetadataMap.entrySet()) {
            Map seriesChunkMetadataMap = (Map)entry.getValue();
            for (Map.Entry seriesChunkMetadataEntry : seriesChunkMetadataMap.entrySet()) {
                sortedChunkMetadataList.add(new Pair<Path, List>((Path)seriesChunkMetadataEntry.getKey(), (List)seriesChunkMetadataEntry.getValue()));
            }
        }
        return sortedChunkMetadataList;
    }
}

