/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.service;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.query.udf.service.UDFClassLoader;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFClassLoaderManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(UDFClassLoaderManager.class);
    private final String libRoot = IoTDBDescriptor.getInstance().getConfig().getUdfDir();
    private final Map<Long, UDFClassLoader> queryIdToUDFClassLoaderMap;
    private volatile UDFClassLoader activeClassLoader;

    UDFClassLoaderManager() {
        logger.info("UDF lib root: {}", (Object)this.libRoot);
        this.queryIdToUDFClassLoaderMap = new ConcurrentHashMap<Long, UDFClassLoader>();
        this.activeClassLoader = null;
    }

    public void initializeUDFQuery(long queryId) {
        this.activeClassLoader.acquire();
        this.queryIdToUDFClassLoaderMap.put(queryId, this.activeClassLoader);
    }

    public void finalizeUDFQuery(long queryId) {
        UDFClassLoader classLoader = this.queryIdToUDFClassLoaderMap.remove(queryId);
        try {
            classLoader.release();
        }
        catch (IOException e) {
            logger.warn("Failed to close UDFClassLoader (queryId: {}), because {}", (Object)queryId, (Object)e.toString());
        }
    }

    public UDFClassLoader updateAndGetActiveClassLoader() throws IOException {
        UDFClassLoader deprecatedClassLoader = this.activeClassLoader;
        this.activeClassLoader = new UDFClassLoader(this.libRoot);
        deprecatedClassLoader.markAsDeprecated();
        return this.activeClassLoader;
    }

    public UDFClassLoader getActiveClassLoader() {
        return this.activeClassLoader;
    }

    @Override
    public void start() throws StartupException {
        try {
            this.makeDirIfNecessary();
            this.activeClassLoader = new UDFClassLoader(this.libRoot);
        }
        catch (IOException e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    private void makeDirIfNecessary() throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(this.libRoot);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.UDF_CLASSLOADER_MANAGER_SERVICE;
    }

    public static UDFClassLoaderManager getInstance() {
        return UDFClassLoaderManagerHelper.INSTANCE;
    }

    private static class UDFClassLoaderManagerHelper {
        private static final UDFClassLoaderManager INSTANCE = new UDFClassLoaderManager();

        private UDFClassLoaderManagerHelper() {
        }
    }
}

