/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileResource
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileResource.class);
    private final File hardlinkOrCopiedFile;
    private volatile long fileSize = -1L;
    private final AtomicInteger referenceCount;

    public PipeTsFileResource(File hardlinkOrCopiedFile) {
        this.hardlinkOrCopiedFile = hardlinkOrCopiedFile;
        this.referenceCount = new AtomicInteger(1);
    }

    public File getFile() {
        return this.hardlinkOrCopiedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileSize() {
        if (this.fileSize == -1L) {
            PipeTsFileResource pipeTsFileResource = this;
            synchronized (pipeTsFileResource) {
                if (this.fileSize == -1L) {
                    this.fileSize = this.hardlinkOrCopiedFile.length();
                }
            }
        }
        return this.fileSize;
    }

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public void increaseReferenceCount() {
        this.referenceCount.addAndGet(1);
    }

    public boolean decreaseReferenceCount() {
        int finalReferenceCount = this.referenceCount.addAndGet(-1);
        if (finalReferenceCount == 0) {
            this.close();
            return true;
        }
        if (finalReferenceCount < 0) {
            LOGGER.warn("PipeTsFileResource's reference count is decreased to below 0.");
        }
        return false;
    }

    @Override
    public synchronized void close() {
        boolean successful = false;
        try {
            successful = Files.deleteIfExists(this.hardlinkOrCopiedFile.toPath());
        }
        catch (Exception e) {
            LOGGER.error("PipeTsFileResource: Failed to delete tsfile {} when closing, because {}. Please MANUALLY delete it.", new Object[]{this.hardlinkOrCopiedFile, e.getMessage(), e});
        }
        if (successful) {
            LOGGER.info("PipeTsFileResource: Closed tsfile {} and cleaned up.", (Object)this.hardlinkOrCopiedFile);
        }
    }
}

