/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.pushsubscription;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.DeviceClientIdInvalidException;
import org.apache.james.jmap.api.model.ExpireTimeInvalidException;
import org.apache.james.jmap.api.model.InvalidPushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionCreationRequest;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscriptionNotFoundException;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionHelpers;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.cassandra.pushsubscription.CassandraPushSubscriptionDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import scala.Option;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class CassandraPushSubscriptionRepository
implements PushSubscriptionRepository {
    private final CassandraPushSubscriptionDAO dao;
    private final Clock clock;

    @Inject
    public CassandraPushSubscriptionRepository(CassandraPushSubscriptionDAO dao, Clock clock) {
        this.dao = dao;
        this.clock = clock;
    }

    public Publisher<PushSubscription> save(Username username, PushSubscriptionCreationRequest request) {
        return Mono.just((Object)request).handle((req, sink) -> {
            if (PushSubscriptionHelpers.isInThePast((Option)req.expires(), (Clock)this.clock)) {
                sink.error((Throwable)new ExpireTimeInvalidException(((PushSubscriptionExpiredTime)req.expires().get()).value(), "expires must be greater than now"));
            }
            if (!this.isUniqueDeviceClientId(username, req.deviceClientId())) {
                sink.error((Throwable)new DeviceClientIdInvalidException(req.deviceClientId(), "deviceClientId must be unique"));
            }
            if (PushSubscriptionHelpers.isInvalidPushSubscriptionKey((Option)req.keys())) {
                sink.error((Throwable)new InvalidPushSubscriptionKeys((PushSubscriptionKeys)req.keys().get()));
            }
        }).thenReturn((Object)PushSubscription.from((PushSubscriptionCreationRequest)request, (PushSubscriptionExpiredTime)PushSubscriptionHelpers.evaluateExpiresTime((Optional)OptionConverters.toJava((Option)request.expires().map(PushSubscriptionExpiredTime::value)), (Clock)this.clock))).flatMap(subscription -> this.dao.insert(username, (PushSubscription)subscription).thenReturn(subscription));
    }

    public Publisher<PushSubscriptionExpiredTime> updateExpireTime(Username username, PushSubscriptionId id, ZonedDateTime newExpire) {
        return Mono.just((Object)newExpire).handle((inputTime, sink) -> {
            if (newExpire.isBefore(ZonedDateTime.now(this.clock))) {
                sink.error((Throwable)new ExpireTimeInvalidException(inputTime, "expires must be greater than now"));
            }
        }).then(this.retrieveByPushSubscriptionId(username, id).flatMap(subscription -> this.dao.insert(username, subscription.withExpires(PushSubscriptionHelpers.evaluateExpiresTime(Optional.of(newExpire), (Clock)this.clock)))).map(PushSubscription::expires).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))));
    }

    public Publisher<Void> updateTypes(Username username, PushSubscriptionId id, Set<TypeName> types) {
        return this.retrieveByPushSubscriptionId(username, id).map(subscription -> subscription.withTypes(CollectionConverters.asScala((Set)types).toSeq())).flatMap(newPushSubscription -> this.dao.insert(username, (PushSubscription)newPushSubscription)).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))).then();
    }

    public Publisher<Void> validateVerificationCode(Username username, PushSubscriptionId id) {
        return this.retrieveByPushSubscriptionId(username, id).map(PushSubscription::verified).flatMap(newPushSubscription -> this.dao.insert(username, (PushSubscription)newPushSubscription)).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))).then();
    }

    public Publisher<Void> revoke(Username username, PushSubscriptionId id) {
        return Mono.from(this.retrieveByPushSubscriptionId(username, id)).flatMap(subscription -> this.dao.deleteOne(username, subscription.deviceClientId())).switchIfEmpty(Mono.empty());
    }

    public Publisher<PushSubscription> get(Username username, Set<PushSubscriptionId> ids) {
        return this.dao.selectAll(username).filter(subscription -> ids.contains(subscription.id())).filter(subscription -> PushSubscriptionHelpers.isNotOutdatedSubscription((PushSubscription)subscription, (Clock)this.clock));
    }

    public Publisher<PushSubscription> list(Username username) {
        return this.dao.selectAll(username).filter(subscription -> PushSubscriptionHelpers.isNotOutdatedSubscription((PushSubscription)subscription, (Clock)this.clock));
    }

    private Mono<PushSubscription> retrieveByPushSubscriptionId(Username username, PushSubscriptionId id) {
        return this.dao.selectAll(username).filter(subscription -> subscription.id().equals((Object)id)).next();
    }

    private boolean isUniqueDeviceClientId(Username username, String deviceClientId) {
        return Boolean.TRUE.equals(this.dao.selectAll(username).filter(subscription -> subscription.deviceClientId().equals(deviceClientId)).count().map(value -> value == 0L).block());
    }
}

