/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.apache.james.blob.objectstorage.aws.BucketNameResolver;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.util.DataChunker;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3BlobStoreDAO
implements BlobStoreDAO,
Startable,
Closeable {
    private static final int CHUNK_SIZE = 0x100000;
    private static final int EMPTY_BUCKET_BATCH_SIZE = 1000;
    private static final int FILE_THRESHOLD = 102400;
    private static final Duration FIRST_BACK_OFF = Duration.ofMillis(100L);
    private static final boolean LAZY = false;
    private static final int MAX_RETRIES = 5;
    private final BucketNameResolver bucketNameResolver;
    private final S3AsyncClient client;
    private final BlobId.Factory blobIdFactory;

    @Inject
    S3BlobStoreDAO(S3BlobStoreConfiguration configuration, BlobId.Factory blobIdFactory) {
        this.blobIdFactory = blobIdFactory;
        AwsS3AuthConfiguration authConfiguration = configuration.getSpecificAuthConfiguration();
        S3Configuration pathStyleAccess = (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build();
        this.client = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)authConfiguration.getAccessKeyId(), (String)authConfiguration.getSecretKey())))).httpClientBuilder((SdkAsyncHttpClient.Builder)NettyNioAsyncHttpClient.builder().tlsTrustManagersProvider(this.getTrustManagerProvider(configuration.getSpecificAuthConfiguration())).maxConcurrency(Integer.valueOf(configuration.getHttpConcurrency())).maxPendingConnectionAcquires(Integer.valueOf(10000)))).endpointOverride(authConfiguration.getEndpoint())).region(configuration.getRegion().asAws())).serviceConfiguration(pathStyleAccess)).build();
        this.bucketNameResolver = BucketNameResolver.builder().prefix(configuration.getBucketPrefix()).namespace(configuration.getNamespace()).build();
    }

    private TlsTrustManagersProvider getTrustManagerProvider(AwsS3AuthConfiguration configuration) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(configuration.getTrustStoreAlgorithm().orElse(TrustManagerFactory.getDefaultAlgorithm()));
            KeyStore trustStore = this.loadTrustStore(configuration);
            trustManagerFactory.init(trustStore);
            return trustManagerFactory::getTrustManagers;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore loadTrustStore(AwsS3AuthConfiguration configuration) {
        KeyStore keyStore;
        if (configuration.getTrustStorePath().isEmpty()) {
            return null;
        }
        FileInputStream trustStoreStream = new FileInputStream(configuration.getTrustStorePath().get());
        try {
            char[] secret = configuration.getTrustStoreSecret().map(String::toCharArray).orElse(null);
            KeyStore trustStore = KeyStore.getInstance(configuration.getTrustStoreType().orElse(KeyStore.getDefaultType()));
            trustStore.load(trustStoreStream, secret);
            keyStore = trustStore;
        }
        catch (Throwable throwable) {
            try {
                try {
                    trustStoreStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        trustStoreStream.close();
        return keyStore;
    }

    @Override
    @PreDestroy
    public void close() {
        this.client.close();
    }

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return ReactorUtils.toInputStream(((FluxResponse)this.getObject((BucketName)resolvedBucketName, (BlobId)blobId).onErrorMap(NoSuchBucketException.class, (Function<NoSuchBucketException, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$read$0(org.apache.james.blob.api.BucketName software.amazon.awssdk.services.s3.model.NoSuchBucketException ), (Lsoftware/amazon/awssdk/services/s3/model/NoSuchBucketException;)Ljava/lang/Throwable;)((BucketName)resolvedBucketName)).onErrorMap(NoSuchKeyException.class, (Function<NoSuchKeyException, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$read$1(org.apache.james.blob.api.BucketName software.amazon.awssdk.services.s3.model.NoSuchKeyException ), (Lsoftware/amazon/awssdk/services/s3/model/NoSuchKeyException;)Ljava/lang/Throwable;)((BucketName)resolvedBucketName)).block()).flux);
    }

    private Mono<FluxResponse> getObject(BucketName bucketName, BlobId blobId) {
        return Mono.fromFuture(() -> this.client.getObject(builder -> builder.bucket(bucketName.asString()).key(blobId.asString()), (AsyncResponseTransformer)new AsyncResponseTransformer<GetObjectResponse, FluxResponse>(){
            FluxResponse response;

            public CompletableFuture<FluxResponse> prepare() {
                this.response = new FluxResponse();
                return this.response.supportingCompletableFuture;
            }

            public void onResponse(GetObjectResponse response) {
                this.response.sdkResponse = response;
            }

            public void exceptionOccurred(Throwable error) {
                this.response.supportingCompletableFuture.completeExceptionally(error);
            }

            public void onStream(SdkPublisher<ByteBuffer> publisher) {
                this.response.flux = Flux.from(publisher);
                this.response.supportingCompletableFuture.complete(this.response);
            }
        })).switchIfEmpty(Mono.error(() -> new ObjectStoreIOException("Request was unexpectedly canceled, no GetObjectResponse")));
    }

    public Mono<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return Mono.fromFuture(() -> this.client.getObject(builder -> builder.bucket(resolvedBucketName.asString()).key(blobId.asString()), AsyncResponseTransformer.toBytes())).onErrorMap(NoSuchBucketException.class, e -> new ObjectNotFoundException("Bucket not found " + resolvedBucketName.asString(), (Throwable)e)).onErrorMap(NoSuchKeyException.class, e -> new ObjectNotFoundException("Blob not found " + resolvedBucketName.asString(), (Throwable)e)).publishOn(Schedulers.parallel()).map(BytesWrapper::asByteArray);
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return Mono.fromFuture(() -> this.client.putObject(builder -> builder.bucket(resolvedBucketName.asString()).key(blobId.asString()).contentLength(Long.valueOf(data.length)), AsyncRequestBody.fromBytes((byte[])data))).retryWhen((Retry)this.createBucketOnRetry(resolvedBucketName)).publishOn(Schedulers.parallel()).then();
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        return this.uploadUsingFile(bucketName, blobId, inputStream);
    }

    private Mono<Void> uploadUsingFile(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        return Mono.using(() -> new FileBackedOutputStream(102400), fileBackedOutputStream -> Mono.fromCallable(() -> IOUtils.copy((InputStream)inputStream, (OutputStream)fileBackedOutputStream)).flatMap(ignore -> this.save(bucketName, blobId, fileBackedOutputStream.asByteSource())), (Consumer)Throwing.consumer(FileBackedOutputStream::reset), (boolean)false).onErrorMap(IOException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).publishOn(Schedulers.parallel());
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return Mono.using(() -> ((ByteSource)content).openStream(), stream -> Mono.fromFuture(() -> this.client.putObject(Throwing.consumer(builder -> builder.bucket(resolvedBucketName.asString()).contentLength(Long.valueOf(content.size())).key(blobId.asString())).sneakyThrow(), AsyncRequestBody.fromPublisher((Publisher)DataChunker.chunkStream((InputStream)stream, (int)0x100000)))), (Consumer)Throwing.consumer(InputStream::close), (boolean)false).retryWhen((Retry)this.createBucketOnRetry(resolvedBucketName)).onErrorMap(IOException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).onErrorMap(SdkClientException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).publishOn(Schedulers.parallel()).then();
    }

    private RetryBackoffSpec createBucketOnRetry(BucketName bucketName) {
        return RetryBackoffSpec.backoff((long)5L, (Duration)FIRST_BACK_OFF).maxAttempts(5L).doBeforeRetryAsync(retrySignal -> {
            if (retrySignal.failure() instanceof NoSuchBucketException) {
                return Mono.fromFuture((CompletableFuture)this.client.createBucket(builder -> builder.bucket(bucketName.asString()))).onErrorResume(BucketAlreadyOwnedByYouException.class, e -> Mono.empty()).then();
            }
            return Mono.error((Throwable)retrySignal.failure());
        });
    }

    public Mono<Void> delete(BucketName bucketName, BlobId blobId) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return Mono.fromFuture(() -> this.client.deleteObject(delete -> delete.bucket(resolvedBucketName.asString()).key(blobId.asString()))).then().onErrorResume(NoSuchBucketException.class, e -> Mono.empty()).publishOn(Schedulers.parallel());
    }

    public Publisher<Void> delete(BucketName bucketName, Collection<BlobId> blobIds) {
        return this.deleteObjects(bucketName, (List)blobIds.stream().map(BlobId::asString).map(id -> (ObjectIdentifier)ObjectIdentifier.builder().key(id).build()).collect(ImmutableList.toImmutableList())).then();
    }

    public Mono<Void> deleteBucket(BucketName bucketName) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.deleteResolvedBucket(resolvedBucketName);
    }

    private Mono<Void> deleteResolvedBucket(BucketName bucketName) {
        return this.emptyBucket(bucketName).onErrorResume(t -> Mono.just((Object)bucketName)).flatMap(ignore -> Mono.fromFuture(() -> this.client.deleteBucket(builder -> builder.bucket(bucketName.asString())))).onErrorResume(t -> Mono.empty()).then().publishOn(Schedulers.parallel());
    }

    private Mono<BucketName> emptyBucket(BucketName bucketName) {
        return Flux.from((Publisher)this.client.listObjectsV2Paginator(builder -> builder.bucket(bucketName.asString()))).flatMap(response -> Flux.fromIterable((Iterable)response.contents()).window(1000).flatMap(this::buildListForBatch, 16).flatMap(identifiers -> this.deleteObjects(bucketName, (List<ObjectIdentifier>)identifiers), 16).then(Mono.just((Object)response))).then(Mono.just((Object)bucketName));
    }

    private Mono<List<ObjectIdentifier>> buildListForBatch(Flux<S3Object> batch) {
        return batch.map(element -> (ObjectIdentifier)ObjectIdentifier.builder().key(element.key()).build()).collect(ImmutableList.toImmutableList());
    }

    private Mono<DeleteObjectsResponse> deleteObjects(BucketName bucketName, List<ObjectIdentifier> identifiers) {
        return Mono.fromFuture(() -> this.client.deleteObjects(builder -> builder.bucket(bucketName.asString()).delete(delete -> delete.objects((Collection)identifiers))));
    }

    @VisibleForTesting
    public Mono<Void> deleteAllBuckets() {
        return Mono.fromFuture(() -> ((S3AsyncClient)this.client).listBuckets()).publishOn(Schedulers.parallel()).flatMapIterable(ListBucketsResponse::buckets).flatMap(bucket -> this.deleteResolvedBucket(BucketName.of((String)bucket.name())), 16).then();
    }

    public Publisher<BucketName> listBuckets() {
        return Mono.fromFuture(() -> ((S3AsyncClient)this.client).listBuckets()).flatMapIterable(ListBucketsResponse::buckets).map(Bucket::name).handle((bucket, sink) -> this.bucketNameResolver.unresolve(BucketName.of((String)bucket)).ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0)));
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return Flux.from((Publisher)this.client.listObjectsV2Paginator(builder -> builder.bucket(bucketName.asString()))).flatMapIterable(ListObjectsV2Response::contents).map(S3Object::key).map(arg_0 -> ((BlobId.Factory)this.blobIdFactory).from(arg_0)).onErrorResume(e -> e.getCause() instanceof NoSuchBucketException, e -> Flux.empty()).onErrorResume(NoSuchBucketException.class, e -> Flux.empty());
    }

    private static /* synthetic */ Throwable lambda$read$1(BucketName resolvedBucketName, NoSuchKeyException e) {
        return new ObjectNotFoundException("Blob not found " + resolvedBucketName.asString(), (Throwable)e);
    }

    private static /* synthetic */ Throwable lambda$read$0(BucketName resolvedBucketName, NoSuchBucketException e) {
        return new ObjectNotFoundException("Bucket not found " + resolvedBucketName.asString(), (Throwable)e);
    }

    private static class FluxResponse {
        final CompletableFuture<FluxResponse> supportingCompletableFuture = new CompletableFuture();
        GetObjectResponse sdkResponse;
        Flux<ByteBuffer> flux;

        private FluxResponse() {
        }
    }
}

