/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.data;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class LdapUsersRepositoryModule
extends AbstractModule {
    public void configure() {
        this.bind(ReadOnlyUsersLDAPRepository.class).in(Scopes.SINGLETON);
        this.bind(UsersRepository.class).to(ReadOnlyUsersLDAPRepository.class);
    }

    @Provides
    @Singleton
    public LdapRepositoryConfiguration provideConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return LdapRepositoryConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("usersrepository"));
    }

    @ProvidesIntoSet
    InitializationOperation configureLdap(LdapRepositoryConfiguration configuration, ReadOnlyUsersLDAPRepository usersRepository) {
        return InitilizationOperationBuilder.forClass(ReadOnlyUsersLDAPRepository.class).init(() -> {
            usersRepository.configure(configuration);
            usersRepository.init();
        });
    }
}

