/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.AbstractSQLWhitelistMatcher;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class IsInWhiteList
extends AbstractSQLWhitelistMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsInWhiteList.class);
    private String selectByPK;

    @Override
    public void init() throws MessagingException {
        super.init();
        this.selectByPK = this.sqlQueries.getSqlString("selectByPK", true);
    }

    @Override
    protected String getSQLSectionName() {
        return "WhiteList";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean matchedWhitelist(MailAddress recipientMailAddress, Mail mail) throws MessagingException {
        Connection conn;
        block23: {
            ResultSet selectRS;
            PreparedStatement selectStmt;
            block22: {
                Domain recipientHost;
                Domain senderHost;
                block26: {
                    block21: {
                        String senderUser;
                        block25: {
                            block20: {
                                String recipientUser;
                                block24: {
                                    block19: {
                                        if (!mail.hasSender()) {
                                            return true;
                                        }
                                        MailAddress senderMailAddress = mail.getMaybeSender().get();
                                        senderUser = senderMailAddress.getLocalPart().toLowerCase(Locale.US);
                                        senderHost = senderMailAddress.getDomain();
                                        conn = null;
                                        selectStmt = null;
                                        selectRS = null;
                                        recipientUser = recipientMailAddress.getLocalPart().toLowerCase(Locale.US);
                                        recipientHost = recipientMailAddress.getDomain();
                                        if (conn == null) {
                                            conn = this.datasource.getConnection();
                                        }
                                        if (selectStmt == null) {
                                            selectStmt = conn.prepareStatement(this.selectByPK);
                                        }
                                        selectStmt.setString(1, recipientUser);
                                        selectStmt.setString(2, recipientHost.asString());
                                        selectStmt.setString(3, senderUser);
                                        selectStmt.setString(4, senderHost.asString());
                                        selectRS = selectStmt.executeQuery();
                                        if (!selectRS.next()) break block19;
                                        boolean bl = true;
                                        this.jdbcUtil.closeJDBCResultSet(selectRS);
                                        this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                                        this.theJDBCUtil.closeJDBCConnection(conn);
                                        return bl;
                                    }
                                    break block24;
                                    {
                                        catch (Throwable throwable) {
                                            this.jdbcUtil.closeJDBCResultSet(selectRS);
                                            this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                                            throw throwable;
                                        }
                                    }
                                }
                                this.jdbcUtil.closeJDBCResultSet(selectRS);
                                this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                                selectStmt = conn.prepareStatement(this.selectByPK);
                                selectStmt.setString(1, recipientUser);
                                selectStmt.setString(2, recipientHost.asString());
                                selectStmt.setString(3, "*");
                                selectStmt.setString(4, senderHost.asString());
                                selectRS = selectStmt.executeQuery();
                                if (!selectRS.next()) break block20;
                                boolean bl = true;
                                this.jdbcUtil.closeJDBCResultSet(selectRS);
                                this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                                this.theJDBCUtil.closeJDBCConnection(conn);
                                return bl;
                            }
                            break block25;
                            {
                                catch (Throwable throwable) {
                                    this.jdbcUtil.closeJDBCResultSet(selectRS);
                                    this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                                    throw throwable;
                                }
                            }
                        }
                        this.jdbcUtil.closeJDBCResultSet(selectRS);
                        this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                        selectStmt = conn.prepareStatement(this.selectByPK);
                        selectStmt.setString(1, "*");
                        selectStmt.setString(2, recipientHost.asString());
                        selectStmt.setString(3, senderUser);
                        selectStmt.setString(4, senderHost.asString());
                        selectRS = selectStmt.executeQuery();
                        if (!selectRS.next()) break block21;
                        boolean bl = true;
                        this.jdbcUtil.closeJDBCResultSet(selectRS);
                        this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                        this.theJDBCUtil.closeJDBCConnection(conn);
                        return bl;
                    }
                    break block26;
                    {
                        catch (Throwable throwable) {
                            this.jdbcUtil.closeJDBCResultSet(selectRS);
                            this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                            throw throwable;
                        }
                    }
                }
                this.jdbcUtil.closeJDBCResultSet(selectRS);
                this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                selectStmt = conn.prepareStatement(this.selectByPK);
                selectStmt.setString(1, "*");
                selectStmt.setString(2, recipientHost.asString());
                selectStmt.setString(3, "*");
                selectStmt.setString(4, senderHost.asString());
                selectRS = selectStmt.executeQuery();
                if (!selectRS.next()) break block22;
                boolean bl = true;
                this.jdbcUtil.closeJDBCResultSet(selectRS);
                this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return bl;
            }
            try {
                this.jdbcUtil.closeJDBCResultSet(selectRS);
                this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                break block23;
                {
                    catch (Throwable throwable) {
                        this.jdbcUtil.closeJDBCResultSet(selectRS);
                        this.jdbcUtil.closeJDBCStatement((Statement)selectStmt);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    LOGGER.error("Error accessing database", (Throwable)sqle);
                    throw new MessagingException("Exception thrown", (Exception)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
        }
        this.theJDBCUtil.closeJDBCConnection(conn);
        return false;
    }

    @Override
    protected String getTableCreateQueryName() {
        return "createWhiteListTable";
    }

    @Override
    protected String getTableName() {
        return "whiteListTableName";
    }
}

