/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.mailbox.model.MessageId;

@JsonDeserialize(builder=Builder.class)
public class GetMessagesRequest
implements JmapRequest {
    private final Optional<String> accountId;
    private final ImmutableList<MessageId> ids;
    private final MessageProperties properties;

    public static Builder builder() {
        return new Builder();
    }

    public GetMessagesRequest(Optional<String> accountId, ImmutableList<MessageId> ids, MessageProperties properties) {
        this.accountId = accountId;
        this.ids = ids;
        this.properties = properties;
    }

    public Optional<String> getAccountId() {
        return this.accountId;
    }

    public ImmutableList<MessageId> getIds() {
        return this.ids;
    }

    public MessageProperties getProperties() {
        return this.properties;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Optional<String> accountId = Optional.empty();
        private final ImmutableList.Builder<MessageId> ids = ImmutableList.builder();
        private Optional<ImmutableSet<String>> properties = Optional.empty();

        private Builder() {
        }

        public Builder accountId(String accountId) {
            this.accountId = Optional.of(accountId);
            return this;
        }

        public Builder ids(List<MessageId> ids) {
            this.ids.addAll(ids);
            return this;
        }

        public Builder properties(List<String> properties) {
            this.properties = Optional.ofNullable(properties).map(ImmutableSet::copyOf);
            return this;
        }

        public GetMessagesRequest build() {
            return new GetMessagesRequest(this.accountId, (ImmutableList<MessageId>)this.ids.build(), new MessageProperties(this.properties));
        }
    }
}

