/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import reactor.core.publisher.Mono;

public class CassandraVacationDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement readStatement;
    private final UserDefinedType zonedDateTimeUserType;
    private final BiFunction<VacationPatch, RegularInsert, RegularInsert> insertGeneratorPipeline;

    @Inject
    public CassandraVacationDAO(CqlSession session, CassandraTypesProvider cassandraTypesProvider) {
        this.zonedDateTimeUserType = cassandraTypesProvider.getDefinedUserType("zonedDateTime");
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"vacation").all().whereColumn("account_id").isEqualTo((Term)QueryBuilder.bindMarker((String)"account_id"))).build());
        this.insertGeneratorPipeline = ImmutableList.of(this.applyPatchForField("subject", VacationPatch::getSubject), this.applyPatchForField("html", VacationPatch::getHtmlBody), this.applyPatchForField("text", VacationPatch::getTextBody), this.applyPatchForField("is_enabled", VacationPatch::getIsEnabled), this.applyPatchForFieldZonedDateTime("from_date", VacationPatch::getFromDate), this.applyPatchForFieldZonedDateTime("to_date", VacationPatch::getToDate)).stream().reduce((vacation, insert) -> insert, (a, b) -> (vacation, insert) -> (RegularInsert)b.apply(vacation, (RegularInsert)a.apply(vacation, insert)));
    }

    public Mono<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.createSpecificUpdate(vacationPatch, QueryBuilder.insertInto((String)"vacation").value("account_id", (Term)QueryBuilder.literal((Object)accountId.getIdentifier()))).build());
    }

    public Mono<Optional<Vacation>> retrieveVacation(AccountId accountId) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.readStatement.bind(new Object[0]).setString("account_id", accountId.getIdentifier())).map(optional -> optional.map(row -> Vacation.builder().enabled(row.getBoolean("is_enabled")).fromDate(this.retrieveDate((Row)row, "from_date")).toDate(this.retrieveDate((Row)row, "to_date")).subject(Optional.ofNullable(row.getString("subject"))).textBody(Optional.ofNullable(row.getString("text"))).htmlBody(Optional.ofNullable(row.getString("html"))).build()));
    }

    private Optional<ZonedDateTime> retrieveDate(Row row, String dateField) {
        return CassandraZonedDateTimeModule.fromUDTOptional((UdtValue)row.getUdtValue(dateField));
    }

    private RegularInsert createSpecificUpdate(VacationPatch vacationPatch, RegularInsert baseInsert) {
        return this.insertGeneratorPipeline.apply(vacationPatch, baseInsert);
    }

    public <T> BiFunction<VacationPatch, RegularInsert, RegularInsert> applyPatchForField(String field, Function<VacationPatch, ValuePatch<T>> getter) {
        return (vacation, insert) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyPatchForField(field, (Optional)optionalValue, (RegularInsert)insert)).orElse(insert);
    }

    public BiFunction<VacationPatch, RegularInsert, RegularInsert> applyPatchForFieldZonedDateTime(String field, Function<VacationPatch, ValuePatch<ZonedDateTime>> getter) {
        return (vacation, insert) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyPatchForField(field, CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.zonedDateTimeUserType, (Optional)optionalValue), (RegularInsert)insert)).orElse(insert);
    }

    private <T> RegularInsert applyPatchForField(String field, Optional<T> value, RegularInsert insert) {
        return insert.value(field, (Term)QueryBuilder.literal(value.orElse(null)));
    }
}

