/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NotificationSubscriptionDetails
implements Serializable {
    private static final long serialVersionUID = 7883889980556267057L;
    @NotNull
    private final List<ASN1OctetString> details;
    @NotNull
    private final String id;

    public NotificationSubscriptionDetails(@NotNull String id, @NotNull Collection<ASN1OctetString> details) {
        Validator.ensureNotNull(id);
        Validator.ensureNotNull(details);
        Validator.ensureFalse(details.isEmpty());
        this.id = id;
        this.details = Collections.unmodifiableList(new ArrayList<ASN1OctetString>(details));
    }

    @NotNull
    public String getID() {
        return this.id;
    }

    @NotNull
    public List<ASN1OctetString> getDetails() {
        return this.details;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("NotificationSubscription(id='");
        buffer.append(this.id);
        buffer.append("')");
    }
}

