/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.github.fge.lambdas.Throwing;
import com.google.common.net.InternetDomainName;
import jakarta.inject.Inject;
import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractSenderAuthIdentifyVerificationHook;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.MemoizedSupplier;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderAuthIdentifyVerificationHook
extends AbstractSenderAuthIdentifyVerificationHook
implements JamesMessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderAuthIdentifyVerificationHook.class);
    private final DomainList domains;
    private final UsersRepository users;
    private final CanSendFrom canSendFrom;

    @Inject
    public SenderAuthIdentifyVerificationHook(DomainList domains, UsersRepository users, CanSendFrom canSendFrom) {
        this.domains = domains;
        this.users = users;
        this.canSendFrom = canSendFrom;
    }

    public HookResult doCheck(SMTPSession session, MaybeSender sender) {
        ExtendedSMTPSession nSession = (ExtendedSMTPSession)session;
        if (nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.STRICT) {
            return super.doCheck(session, sender);
        }
        if (nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.RELAXED) {
            return this.doCheckRelaxed(session, sender);
        }
        return HookResult.DECLINED;
    }

    private HookResult doCheckRelaxed(SMTPSession session, MaybeSender sender) {
        if (this.senderDoesNotMatchAuthUser(session, sender)) {
            LOGGER.warn("{} tried to send an email as {}", (Object)session.getUsername(), (Object)sender.asString());
            return INVALID_AUTH;
        }
        if (this.unauthenticatedSenderIsLocalUser(session, sender)) {
            if (this.mxHeuristic(session)) {
                return HookResult.DECLINED;
            }
            LOGGER.info("Authentication is required for sending emails as a local user ({}) - we infered the sender not to be a MX so the check is enforced.", (Object)sender.asString());
            return AUTH_REQUIRED;
        }
        return HookResult.DECLINED;
    }

    private boolean mxHeuristic(SMTPSession session) {
        Optional helo = session.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection);
        return helo.filter(InternetDomainName::isValid).map(name -> name.contains(".")).orElse(false);
    }

    protected boolean isLocalDomain(Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            return false;
        }
    }

    protected Username getUser(MailAddress mailAddress) {
        try {
            return this.users.getUsername(mailAddress);
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isSenderAllowed(Username connectedUser, Username sender) {
        boolean allowed = this.canSendFrom.userCanSendFrom(connectedUser, sender);
        if (allowed) {
            LOGGER.debug("{} is allowed to send a mail using {} identity", (Object)connectedUser.asString(), (Object)sender.asString());
        } else {
            LOGGER.info("{} is not allowed to send a mail using {} identity", (Object)connectedUser.asString(), (Object)sender.asString());
        }
        return allowed;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        boolean shouldCheck;
        ExtendedSMTPSession nSession = (ExtendedSMTPSession)session;
        boolean bl = shouldCheck = nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.STRICT || nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.RELAXED && session.getUsername() != null;
        if (shouldCheck) {
            try {
                Object[] fromAddresses = mail.getMessage().getFrom();
                if (fromAddresses == null || fromAddresses.length == 0) {
                    return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("503").smtpDescription(DSNStatus.getStatus((int)5, (String)"5.4") + " Missing From header").build();
                }
                return StreamUtils.ofNullable((Object[])fromAddresses).distinct().flatMap(address -> this.doCheckMessage(session, (Address)address)).findFirst().orElse(HookResult.DECLINED);
            }
            catch (MessagingException e) {
                if (session.getUsername() == null) {
                    return HookResult.DECLINED;
                }
                LOGGER.warn("Local user {} attempted to use an invalid From header", (Object)session.getUsername(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        return HookResult.DECLINED;
    }

    private Stream<HookResult> doCheckMessage(SMTPSession session, Address from) {
        if (this.fromDoesNotMatchAuthUser(session, from)) {
            return Stream.of(INVALID_AUTH);
        }
        return Stream.empty();
    }

    private boolean fromDoesNotMatchAuthUser(SMTPSession session, Address from) {
        if (from instanceof InternetAddress) {
            InternetAddress internetAddress = (InternetAddress)from;
            try {
                if (internetAddress.isGroup()) {
                    boolean strict = true;
                    InternetAddress[] addressGroup = internetAddress.getGroup(!strict);
                    if (session.getUsername() != null && addressGroup.length == 0) {
                        return true;
                    }
                    return Arrays.stream(addressGroup).map(address -> this.fromDoesNotMatchAuthUser(session, (InternetAddress)address)).filter(b -> b).findAny().orElse(false);
                }
                return this.fromDoesNotMatchAuthUser(session, internetAddress);
            }
            catch (AddressException e) {
                LOGGER.warn("Local user {} attempted to use an invalid From header", (Object)session.getUsername(), (Object)e);
                return session.getUsername() != null;
            }
        }
        return false;
    }

    private boolean fromDoesNotMatchAuthUser(SMTPSession session, InternetAddress internetAddress) {
        MemoizedSupplier mailAddress = MemoizedSupplier.of((Supplier)Throwing.supplier(() -> new MailAddress(internetAddress.getAddress())).sneakyThrow());
        return session.getUsername() != null && (!this.fromMatchSessionUser((MailAddress)mailAddress.get(), session) || !this.belongsToLocalDomain((MailAddress)mailAddress.get()));
    }

    private boolean fromMatchSessionUser(MailAddress from, SMTPSession session) {
        Username authUser = session.getUsername();
        Username sender = this.getUser(from);
        return this.isSenderAllowed(authUser, sender);
    }

    private boolean belongsToLocalDomain(MailAddress from) {
        return this.isLocalDomain(from.getDomain());
    }
}

