/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ASN1StreamReaderSequence {
    @NotNull
    private final ASN1StreamReader reader;
    private final byte type;
    private final int length;
    private final long endBytesRead;

    ASN1StreamReaderSequence(@NotNull ASN1StreamReader reader, byte type, int length) {
        this.reader = reader;
        this.type = type;
        this.length = length;
        this.endBytesRead = reader.getTotalBytesRead() + (long)length;
    }

    public byte getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasMoreElements() throws ASN1Exception {
        long currentBytesRead = this.reader.getTotalBytesRead();
        if (currentBytesRead == this.endBytesRead) {
            return false;
        }
        if (currentBytesRead < this.endBytesRead) {
            return true;
        }
        throw new ASN1Exception(ASN1Messages.ERR_STREAM_READER_SEQUENCE_READ_PAST_END.get(this.length, this.endBytesRead, currentBytesRead));
    }
}

