/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.jena.atlas.lib.Alarm;

public class AlarmClock {
    private static ThreadFactory threadFactory = BasicThreadFactory.builder().daemon(true).namingPattern("alarm-clock-%d").build();
    private ScheduledThreadPoolExecutor timer = new ScheduledThreadPoolExecutor(1, threadFactory);
    private static AlarmClock singleton = new AlarmClock();

    AlarmClock() {
    }

    public static AlarmClock get() {
        return singleton;
    }

    public Alarm add(Runnable task, long delay) {
        if (task == null) {
            throw new IllegalArgumentException("Task is null");
        }
        ScheduledFuture<?> future = this.timer.schedule(task, delay, TimeUnit.MILLISECONDS);
        return new Alarm(this, task, future);
    }

    public Alarm reset(Alarm alarm, long delay) {
        this.cancel(alarm);
        return this.add(alarm.task, delay);
    }

    public void cancel(Alarm alarm) {
        alarm.future.cancel(false);
    }

    public void release() {
        this.timer.shutdownNow();
    }
}

