/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.great_circle;

import org.apache.jena.geosparql.implementation.great_circle.LatLonPoint;

public class GreatCirclePointDistance {
    private final double distance;
    private final double angDistance;
    private final double startLat;
    private final double startLon;
    private final double latRad;
    private final double lonRad;
    private final double sinStartLat;
    private final double cosStartLat;
    private final double sinAngDistance;
    private final double cosAngDistance;

    public GreatCirclePointDistance(double startLat, double startLon, double distance) {
        this.distance = distance;
        this.startLat = startLat;
        this.startLon = startLon;
        this.angDistance = distance / 6371008.7714;
        this.latRad = Math.toRadians(startLat);
        this.lonRad = Math.toRadians(startLon);
        this.sinStartLat = Math.sin(this.latRad);
        this.cosStartLat = Math.cos(this.latRad);
        this.sinAngDistance = Math.sin(this.angDistance);
        this.cosAngDistance = Math.cos(this.angDistance);
    }

    public double getDistance() {
        return this.distance;
    }

    public double getAngDistance() {
        return this.angDistance;
    }

    public double getStartLat() {
        return this.startLat;
    }

    public double getStartLon() {
        return this.startLon;
    }

    public double getLatRad() {
        return this.latRad;
    }

    public double getLonRad() {
        return this.lonRad;
    }

    public double getSinStartLat() {
        return this.sinStartLat;
    }

    public double getCosStartLat() {
        return this.cosStartLat;
    }

    public double getSinAngDistance() {
        return this.sinAngDistance;
    }

    public double getCosAngDistance() {
        return this.cosAngDistance;
    }

    public String toString() {
        return "GreatCirclePointDistance{distance=" + this.distance + ", angDistance=" + this.angDistance + ", startLat=" + this.startLat + ", startLon=" + this.startLon + ", latRad=" + this.latRad + ", lonRad=" + this.lonRad + ", sinStartLat=" + this.sinStartLat + ", cosStartLat=" + this.cosStartLat + ", sinAngDistance=" + this.sinAngDistance + ", cosAngDistance=" + this.cosAngDistance + "}";
    }

    public double latitude(double bearingRad) {
        return Math.asin(this.sinStartLat * this.cosAngDistance + this.cosStartLat * this.sinAngDistance * Math.cos(bearingRad));
    }

    public double longitude(double endLatRad, double bearingRad) {
        return this.lonRad + Math.atan2(Math.sin(bearingRad) * this.sinAngDistance * this.cosStartLat, this.cosAngDistance - this.sinStartLat * Math.sin(endLatRad));
    }

    public static final LatLonPoint radToPoint(double latRad, double lonRad) {
        return GreatCirclePointDistance.radToPoint(latRad, lonRad, true);
    }

    public static final LatLonPoint radToPoint(double latRad, double lonRad, boolean isNormaliseLon) {
        double lat = Math.toDegrees(latRad);
        double lon = Math.toDegrees(lonRad);
        if (isNormaliseLon) {
            lon = GreatCirclePointDistance.normaliseLongitude(lon);
        }
        LatLonPoint point = new LatLonPoint(lat, lon);
        return point;
    }

    public static double normaliseLongitude(double lonDegrees) {
        if (lonDegrees > 180.0) {
            return lonDegrees - 360.0;
        }
        if (lonDegrees < -180.0) {
            return lonDegrees + 380.0;
        }
        return lonDegrees;
    }

    public static final LatLonPoint getPoint(LatLonPoint startPoint, double distance, double bearing) {
        double startLat = startPoint.getLat();
        double startLon = startPoint.getLon();
        return GreatCirclePointDistance.getPoint(startLat, startLon, distance, bearing);
    }

    public static final LatLonPoint getPoint(double startLat, double startLon, double distance, double bearing) {
        double bearingRad = Math.toRadians(bearing);
        GreatCirclePointDistance pointDistance = new GreatCirclePointDistance(startLat, startLon, distance);
        double endLatRad = pointDistance.latitude(bearingRad);
        double endLonRad = pointDistance.longitude(endLatRad, bearingRad);
        LatLonPoint endPoint = GreatCirclePointDistance.radToPoint(endLatRad, endLonRad);
        return endPoint;
    }
}

