/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.time.interval;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.core.commons.time.TimeUtil;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H$J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H$J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/MeasuredInDays;", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "count", "", "(I)V", "addInterval", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "toInstant", "getFirstDayContaining", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "instant", "range", "", "", "start", "end", "plot-base"})
public abstract class MeasuredInDays
extends TimeInterval {
    protected MeasuredInDays(int count) {
        super(count);
    }

    @NotNull
    protected abstract Date getFirstDayContaining(@NotNull DateTime var1);

    @Override
    @NotNull
    public List<Double> range(double start2, double end) {
        if (start2 > end) {
            throw new RuntimeException("Duration must be positive");
        }
        DateTime dateTimeStart = TimeUtil.INSTANCE.asDateTimeUTC(start2);
        Date dateStart = this.getFirstDayContaining(dateTimeStart);
        DateTime dateTimeTick = new DateTime(dateStart, null, 2, null);
        if (dateTimeTick.compareTo(dateTimeStart) < 0) {
            dateTimeTick = this.addInterval(dateTimeTick);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        double tick = TimeUtil.INSTANCE.asInstantUTC(dateTimeTick);
        while (tick <= end) {
            result.add(tick);
            dateTimeTick = this.addInterval(dateTimeTick);
            tick = TimeUtil.INSTANCE.asInstantUTC(dateTimeTick);
        }
        return result;
    }

    @NotNull
    protected abstract DateTime addInterval(@NotNull DateTime var1);
}

