/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.smtp.sampler.gui.SecuritySettingsPanel;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.util.JMeterUtils;

public class SmtpPanel
extends JPanel {
    private static final long serialVersionUID = 2L;
    private JTextField tfMailFrom;
    private JTextField tfMailReplyTo;
    private JButton browseButton;
    private JButton emlBrowseButton;
    private JCheckBox cbUseAuth;
    private JTextField tfMailServer;
    private JTextField tfMailServerPort;
    private JTextField tfMailServerTimeout;
    private JTextField tfMailServerConnectionTimeout;
    private JTextField tfMailTo;
    private JTextField tfMailToCC;
    private JTextField tfMailToBCC;
    private JTextField tfAttachment;
    private JTextField tfEmlMessage;
    private JTextArea taMessage;
    private JCheckBox cbPlainBody;
    private JFileChooser attachmentFileChooser;
    private JFileChooser emlFileChooser;
    private JTextField tfAuthPassword;
    private JTextField tfAuthUsername;
    private JTextField tfSubject;
    private JCheckBox cbSuppressSubject;
    private JCheckBox cbIncludeTimestamp;
    private JCheckBox cbMessageSizeStats;
    private JCheckBox cbEnableDebug;
    private JCheckBox cbUseEmlMessage;
    private JPanel headerFieldsPanel;
    private JButton addHeaderFieldButton;
    private JLabel headerFieldName;
    private JLabel headerFieldValue;
    private final Map<JTextField, JTextField> headerFields = new HashMap<JTextField, JTextField>();
    private final Map<JButton, JTextField> removeButtons = new HashMap<JButton, JTextField>();
    private int headerGridY = 0;
    private SecuritySettingsPanel securitySettingsPanel;

    public SmtpPanel() {
        this.initComponents();
    }

    public String getMailFrom() {
        return this.tfMailFrom.getText();
    }

    public String getReceiverTo() {
        return this.tfMailTo.getText();
    }

    public String getReceiverCC() {
        return this.tfMailToCC.getText();
    }

    public String getReceiverBCC() {
        return this.tfMailToBCC.getText();
    }

    public String getBody() {
        return this.taMessage.getText();
    }

    public void setBody(String messageBodyText) {
        this.taMessage.setText(messageBodyText);
    }

    public void setMailFrom(String mailFrom) {
        this.tfMailFrom.setText(mailFrom);
    }

    public void setReceiverTo(String mailTo) {
        this.tfMailTo.setText(mailTo);
    }

    public void setReceiverCC(String mailToCC) {
        this.tfMailToCC.setText(mailToCC);
    }

    public void setReceiverBCC(String mailToBCC) {
        this.tfMailToBCC.setText(mailToBCC);
    }

    public String getAttachments() {
        return this.tfAttachment.getText();
    }

    public void setAttachments(String attachments) {
        this.tfAttachment.setText(attachments);
    }

    public String getPort() {
        return this.tfMailServerPort.getText();
    }

    public void setPort(String port) {
        this.tfMailServerPort.setText(port);
    }

    public String getServer() {
        return this.tfMailServer.getText();
    }

    public void setServer(String server) {
        this.tfMailServer.setText(server);
    }

    public String getTimeout() {
        return this.tfMailServerTimeout.getText();
    }

    public void setTimeout(String timeout) {
        this.tfMailServerTimeout.setText(timeout);
    }

    public String getConnectionTimeout() {
        return this.tfMailServerConnectionTimeout.getText();
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.tfMailServerConnectionTimeout.setText(connectionTimeout);
    }

    public String getSubject() {
        return this.tfSubject.getText();
    }

    public void setSubject(String subject) {
        this.tfSubject.setText(subject);
    }

    public boolean isSuppressSubject() {
        return this.cbSuppressSubject.isSelected();
    }

    public void setSuppressSubject(boolean emptySubject) {
        this.cbSuppressSubject.setSelected(emptySubject);
    }

    public boolean isPlainBody() {
        return this.cbPlainBody.isSelected();
    }

    public void setPlainBody(boolean plainBody) {
        this.cbPlainBody.setSelected(plainBody);
    }

    public boolean isUseAuth() {
        return this.cbUseAuth.isSelected();
    }

    public void setUseAuth(boolean selected) {
        this.cbUseAuth.setSelected(selected);
        this.tfAuthPassword.setEditable(selected);
        this.tfAuthUsername.setEditable(selected);
    }

    public boolean isEnableDebug() {
        return this.cbEnableDebug.isSelected();
    }

    public void setEnableDebug(boolean selected) {
        this.cbEnableDebug.setSelected(selected);
    }

    public boolean isUseEmlMessage() {
        return this.cbUseEmlMessage.isSelected();
    }

    public void setUseEmlMessage(boolean useEmlMessage) {
        this.cbUseEmlMessage.setSelected(useEmlMessage);
    }

    public String getEmlMessage() {
        return this.tfEmlMessage.getText();
    }

    public void setEmlMessage(String emlMessage) {
        this.tfEmlMessage.setText(emlMessage);
    }

    public boolean isIncludeTimestamp() {
        return this.cbIncludeTimestamp.isSelected();
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.cbIncludeTimestamp.setSelected(includeTimestamp);
    }

    public boolean isMessageSizeStatistics() {
        return this.cbMessageSizeStats.isSelected();
    }

    public void setMessageSizeStatistic(boolean val) {
        this.cbMessageSizeStats.setSelected(val);
    }

    public String getPassword() {
        return this.tfAuthPassword.getText();
    }

    public void setPassword(String authPassword) {
        this.tfAuthPassword.setText(authPassword);
    }

    public String getUsername() {
        return this.tfAuthUsername.getText();
    }

    public void setUsername(String username) {
        this.tfAuthUsername.setText(username);
    }

    public CollectionProperty getHeaderFields() {
        CollectionProperty result = new CollectionProperty();
        result.setName("SMTPSampler.headerFields");
        for (Map.Entry<JTextField, JTextField> header : this.headerFields.entrySet()) {
            String name = header.getKey().getText();
            String value = header.getValue().getText();
            Argument argument = new Argument(name, value);
            result.addItem((Object)argument);
        }
        return result;
    }

    public void setHeaderFields(CollectionProperty fields) {
        this.clearHeaderFields();
        for (int i = 0; i < fields.size(); ++i) {
            Argument argument = (Argument)fields.get(i).getObjectValue();
            String name = argument.getName();
            JButton removeButton = this.addHeaderActionPerformed(null);
            JTextField nameTF = this.removeButtons.get(removeButton);
            nameTF.setText(name);
            JTextField valueTF = this.headerFields.get(nameTF);
            valueTF.setText(argument.getValue());
        }
        this.validate();
    }

    public String getMailReplyTo() {
        return this.tfMailReplyTo.getText();
    }

    public void setMailReplyTo(String replyTo) {
        this.tfMailReplyTo.setText(replyTo);
    }

    private void initComponents() {
        JLabel jlAddressReplyTo = new JLabel(JMeterUtils.getResString((String)"smtp_replyto"));
        JLabel jlAddressFrom = new JLabel(JMeterUtils.getResString((String)"smtp_from"));
        JLabel jlAddressTo = new JLabel(JMeterUtils.getResString((String)"smtp_to"));
        JLabel jlAddressToCC = new JLabel(JMeterUtils.getResString((String)"smtp_cc"));
        JLabel jlAddressToBCC = new JLabel(JMeterUtils.getResString((String)"smtp_bcc"));
        JLabel jlMailServerPort = new JLabel(JMeterUtils.getResString((String)"smtp_server_port"));
        JLabel jlMailServer = new JLabel(JMeterUtils.getResString((String)"smtp_server"));
        JLabel jlMailServerTimeout = new JLabel(JMeterUtils.getResString((String)"smtp_server_timeout"));
        JLabel jlMailServerConnectionTimeout = new JLabel(JMeterUtils.getResString((String)"smtp_server_connection_timeout"));
        JLabel jlAttachFile = new JLabel(JMeterUtils.getResString((String)"smtp_attach_file"));
        JLabel jlDutPortStandard = new JLabel(JMeterUtils.getResString((String)"smtp_default_port"));
        JLabel jlUsername = new JLabel(JMeterUtils.getResString((String)"smtp_username"));
        JLabel jlPassword = new JLabel(JMeterUtils.getResString((String)"smtp_password"));
        JLabel jlSubject = new JLabel(JMeterUtils.getResString((String)"smtp_subject"));
        JLabel jlMessage = new JLabel(JMeterUtils.getResString((String)"smtp_message"));
        this.tfMailServer = new JTextField(30);
        this.tfMailServerPort = new JTextField(6);
        this.tfMailServerTimeout = new JTextField(6);
        this.tfMailServerConnectionTimeout = new JTextField(6);
        this.tfMailFrom = new JTextField(25);
        this.tfMailReplyTo = new JTextField(25);
        this.tfMailTo = new JTextField(25);
        this.tfMailToCC = new JTextField(25);
        this.tfMailToBCC = new JTextField(25);
        this.tfAuthUsername = new JTextField(20);
        this.tfAuthPassword = new JPasswordField(20);
        this.tfSubject = new JTextField(20);
        this.tfAttachment = new JTextField(30);
        this.tfEmlMessage = new JTextField(30);
        this.taMessage = new JTextArea(5, 20);
        this.cbPlainBody = new JCheckBox(JMeterUtils.getResString((String)"smtp_plainbody"));
        this.cbSuppressSubject = new JCheckBox(JMeterUtils.getResString((String)"smtp_suppresssubj"));
        this.cbSuppressSubject.addChangeListener(this::emptySubjectActionPerformed);
        this.cbUseAuth = new JCheckBox(JMeterUtils.getResString((String)"smtp_useauth"));
        this.cbIncludeTimestamp = new JCheckBox(JMeterUtils.getResString((String)"smtp_timestamp"));
        this.cbMessageSizeStats = new JCheckBox(JMeterUtils.getResString((String)"smtp_messagesize"));
        this.cbEnableDebug = new JCheckBox(JMeterUtils.getResString((String)"smtp_enabledebug"));
        this.cbUseEmlMessage = new JCheckBox(JMeterUtils.getResString((String)"smtp_eml"));
        this.attachmentFileChooser = new JFileChooser();
        this.emlFileChooser = new JFileChooser();
        this.browseButton = new JButton(JMeterUtils.getResString((String)"browse"));
        this.emlBrowseButton = new JButton(JMeterUtils.getResString((String)"browse"));
        this.attachmentFileChooser.addActionListener(this::attachmentFolderFileChooserActionPerformed);
        this.emlFileChooser.addActionListener(this::emlFileChooserActionPerformed);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraintsMain = new GridBagConstraints();
        gridBagConstraintsMain.fill = 2;
        gridBagConstraintsMain.anchor = 17;
        gridBagConstraintsMain.weightx = 0.5;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        VerticalPanel panelServerSettings = new VerticalPanel();
        panelServerSettings.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smtp_server_settings")));
        JPanel panelMailServer = new JPanel(new BorderLayout(5, 0));
        panelMailServer.add((Component)jlMailServer, "West");
        panelMailServer.add((Component)this.tfMailServer, "Center");
        JPanel panelMailServerPort = new JPanel(new BorderLayout(5, 0));
        panelMailServerPort.add((Component)jlMailServerPort, "West");
        panelMailServerPort.add((Component)this.tfMailServerPort, "Center");
        panelMailServerPort.add((Component)jlDutPortStandard, "East");
        panelServerSettings.add((Component)panelMailServer, "Center");
        panelServerSettings.add((Component)panelMailServerPort, "South");
        VerticalPanel panelServerTimeoutsSettings = new VerticalPanel();
        panelServerTimeoutsSettings.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smtp_server_timeouts_settings")));
        JPanel panelMailServerConnectionTimeout = new JPanel(new BorderLayout(5, 0));
        panelMailServerConnectionTimeout.add((Component)jlMailServerConnectionTimeout, "West");
        panelMailServerConnectionTimeout.add((Component)this.tfMailServerConnectionTimeout, "Center");
        JPanel panelMailServerTimeout = new JPanel(new BorderLayout(5, 0));
        panelMailServerTimeout.add((Component)jlMailServerTimeout, "West");
        panelMailServerTimeout.add((Component)this.tfMailServerTimeout, "Center");
        panelServerTimeoutsSettings.add((Component)panelMailServerConnectionTimeout, "Center");
        panelServerTimeoutsSettings.add((Component)panelMailServerTimeout, "South");
        HorizontalPanel panelServerConfig = new HorizontalPanel();
        panelServerConfig.add((Component)panelServerSettings, "Center");
        panelServerConfig.add((Component)panelServerTimeoutsSettings, "East");
        gridBagConstraintsMain.gridx = 0;
        gridBagConstraintsMain.gridy = 0;
        this.add((Component)panelServerConfig, gridBagConstraintsMain);
        JPanel panelMailSettings = new JPanel(new GridBagLayout());
        panelMailSettings.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smtp_mail_settings")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panelMailSettings.add((Component)jlAddressFrom, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        panelMailSettings.add((Component)this.tfMailFrom, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        panelMailSettings.add((Component)jlAddressTo, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        panelMailSettings.add((Component)this.tfMailTo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        panelMailSettings.add((Component)jlAddressToCC, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        panelMailSettings.add((Component)this.tfMailToCC, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        panelMailSettings.add((Component)jlAddressToBCC, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        panelMailSettings.add((Component)this.tfMailToBCC, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        panelMailSettings.add((Component)jlAddressReplyTo, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        panelMailSettings.add((Component)this.tfMailReplyTo, gridBagConstraints);
        gridBagConstraintsMain.gridx = 0;
        gridBagConstraintsMain.gridy = 1;
        this.add((Component)panelMailSettings, gridBagConstraintsMain);
        JPanel panelAuthSettings = new JPanel(new GridBagLayout());
        panelAuthSettings.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smtp_auth_settings")));
        this.cbUseAuth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbUseAuth.setMargin(new Insets(0, 0, 0, 0));
        this.cbUseAuth.addActionListener(this::cbUseAuthActionPerformed);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panelAuthSettings.add((Component)this.cbUseAuth, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        panelAuthSettings.add((Component)jlUsername, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        panelAuthSettings.add((Component)this.tfAuthUsername, gridBagConstraints);
        this.tfAuthUsername.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        panelAuthSettings.add((Component)jlPassword, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        panelAuthSettings.add((Component)this.tfAuthPassword, gridBagConstraints);
        this.tfAuthPassword.setEditable(false);
        gridBagConstraintsMain.gridx = 0;
        gridBagConstraintsMain.gridy = 2;
        this.add((Component)panelAuthSettings, gridBagConstraintsMain);
        this.securitySettingsPanel = new SecuritySettingsPanel();
        gridBagConstraintsMain.gridx = 0;
        gridBagConstraintsMain.gridy = 3;
        this.add((Component)this.securitySettingsPanel, gridBagConstraintsMain);
        JPanel panelMessageSettings = new JPanel(new GridBagLayout());
        panelMessageSettings.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smtp_message_settings")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panelMessageSettings.add((Component)jlSubject, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        panelMessageSettings.add((Component)this.tfSubject, gridBagConstraints);
        this.cbSuppressSubject.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSuppressSubject.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        panelMessageSettings.add((Component)this.cbSuppressSubject, gridBagConstraints);
        this.cbIncludeTimestamp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbIncludeTimestamp.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        panelMessageSettings.add((Component)this.cbIncludeTimestamp, gridBagConstraints);
        this.addHeaderFieldButton = new JButton(JMeterUtils.getResString((String)"smtp_header_add"));
        this.addHeaderFieldButton.addActionListener(this::addHeaderActionPerformed);
        this.headerFieldName = new JLabel(JMeterUtils.getResString((String)"smtp_header_name"));
        this.headerFieldValue = new JLabel(JMeterUtils.getResString((String)"smtp_header_value"));
        this.headerFieldsPanel = new JPanel(new GridBagLayout());
        this.headerFieldName.setVisible(false);
        this.headerFieldValue.setVisible(false);
        this.headerGridY = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.headerGridY++;
        this.headerFieldsPanel.add((Component)this.addHeaderFieldButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.headerGridY;
        this.headerFieldsPanel.add((Component)this.headerFieldName, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.headerGridY++;
        this.headerFieldsPanel.add((Component)this.headerFieldValue, gridBagConstraints);
        gridBagConstraintsMain.gridx = 1;
        gridBagConstraintsMain.gridy = 2;
        panelMessageSettings.add((Component)this.headerFieldsPanel, gridBagConstraintsMain);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        panelMessageSettings.add((Component)jlMessage, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        panelMessageSettings.add((Component)this.taMessage, gridBagConstraints);
        this.cbPlainBody.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbPlainBody.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        panelMessageSettings.add((Component)this.cbPlainBody, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        panelMessageSettings.add((Component)jlAttachFile, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        panelMessageSettings.add((Component)this.tfAttachment, gridBagConstraints);
        this.tfAttachment.setToolTipText(JMeterUtils.getResString((String)"smtp_attach_file_tooltip"));
        this.browseButton.addActionListener(this::browseButtonActionPerformed);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        panelMessageSettings.add((Component)this.browseButton, gridBagConstraints);
        this.cbUseEmlMessage.setSelected(false);
        this.cbUseEmlMessage.addActionListener(this::cbUseEmlMessageActionPerformed);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        panelMessageSettings.add((Component)this.cbUseEmlMessage, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.tfEmlMessage.setEnabled(false);
        panelMessageSettings.add((Component)this.tfEmlMessage, gridBagConstraints);
        this.emlBrowseButton.addActionListener(this::emlBrowseButtonActionPerformed);
        this.emlBrowseButton.setEnabled(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        panelMessageSettings.add((Component)this.emlBrowseButton, gridBagConstraints);
        gridBagConstraintsMain.gridx = 0;
        gridBagConstraintsMain.gridy = 6;
        this.add((Component)panelMessageSettings, gridBagConstraintsMain);
        JPanel panelAdditionalSettings = new JPanel(new GridBagLayout());
        panelAdditionalSettings.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smtp_additional_settings")));
        this.cbMessageSizeStats.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbMessageSizeStats.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panelAdditionalSettings.add((Component)this.cbMessageSizeStats, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        panelAdditionalSettings.add((Component)this.cbEnableDebug, gridBagConstraints);
        gridBagConstraintsMain.gridx = 0;
        gridBagConstraintsMain.gridy = 7;
        this.add((Component)panelAdditionalSettings, gridBagConstraintsMain);
    }

    private void cbUseAuthActionPerformed(ActionEvent evt) {
        this.tfAuthUsername.setEditable(this.cbUseAuth.isSelected());
        this.tfAuthPassword.setEditable(this.cbUseAuth.isSelected());
    }

    private void attachmentFolderFileChooserActionPerformed(ActionEvent evt) {
        File chosen = this.attachmentFileChooser.getSelectedFile();
        if (chosen == null) {
            return;
        }
        String attachments = this.tfAttachment.getText().trim();
        if (attachments.length() > 0) {
            this.tfAttachment.setText(attachments + ";" + chosen.getAbsolutePath());
        } else {
            this.tfAttachment.setText(chosen.getAbsolutePath());
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.attachmentFileChooser.showOpenDialog(this);
    }

    private void cbUseEmlMessageActionPerformed(ActionEvent evt) {
        if (this.cbUseEmlMessage.isSelected()) {
            this.tfEmlMessage.setEnabled(true);
            this.emlBrowseButton.setEnabled(true);
            this.taMessage.setEnabled(false);
            this.tfAttachment.setEnabled(false);
            this.browseButton.setEnabled(false);
        } else {
            this.tfEmlMessage.setEnabled(false);
            this.emlBrowseButton.setEnabled(false);
            this.taMessage.setEnabled(true);
            this.tfAttachment.setEnabled(true);
            this.browseButton.setEnabled(true);
        }
    }

    private void emlFileChooserActionPerformed(ActionEvent evt) {
        this.tfEmlMessage.setText(this.emlFileChooser.getSelectedFile().getAbsolutePath());
    }

    private void emlBrowseButtonActionPerformed(ActionEvent evt) {
        this.emlFileChooser.showOpenDialog(this);
    }

    public void clear() {
        this.cbIncludeTimestamp.setSelected(false);
        this.cbMessageSizeStats.setSelected(false);
        this.cbEnableDebug.setSelected(false);
        this.cbUseEmlMessage.setSelected(false);
        this.cbUseAuth.setSelected(false);
        this.taMessage.setText("");
        this.tfAttachment.setText("");
        this.tfAuthPassword.setText("");
        this.tfAuthUsername.setText("");
        this.tfEmlMessage.setText("");
        this.tfMailFrom.setText("");
        this.tfMailReplyTo.setText("");
        this.tfMailServer.setText("");
        this.tfMailServerPort.setText("");
        this.tfMailServerConnectionTimeout.setText("");
        this.tfMailServerTimeout.setText("");
        this.tfMailTo.setText("");
        this.tfMailToBCC.setText("");
        this.tfMailToCC.setText("");
        this.tfSubject.setText("");
        this.cbPlainBody.setSelected(false);
        this.cbSuppressSubject.setSelected(false);
        this.securitySettingsPanel.clear();
        this.clearHeaderFields();
        this.validate();
    }

    private void clearHeaderFields() {
        this.headerFieldName.setVisible(false);
        this.headerFieldValue.setVisible(false);
        Iterator<JButton> iterator = this.removeButtons.keySet().iterator();
        while (iterator.hasNext()) {
            JButton removeButton = iterator.next();
            JTextField headerName = this.removeButtons.get(removeButton);
            JTextField headerValue = this.headerFields.get(headerName);
            this.headerFieldsPanel.remove(headerName);
            if (headerValue != null) {
                this.headerFieldsPanel.remove(headerValue);
            }
            this.headerFieldsPanel.remove(removeButton);
            this.headerFields.remove(headerName);
            iterator.remove();
        }
    }

    private JButton addHeaderActionPerformed(ActionEvent evt) {
        if (this.headerFields.isEmpty()) {
            this.headerFieldName.setVisible(true);
            this.headerFieldValue.setVisible(true);
        }
        JTextField nameTF = new JTextField();
        JTextField valueTF = new JTextField();
        JButton removeButton = new JButton(JMeterUtils.getResString((String)"smtp_header_remove"));
        this.headerFields.put(nameTF, valueTF);
        this.removeButtons.put(removeButton, nameTF);
        removeButton.addActionListener(this::removeHeaderActionPerformed);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.headerGridY;
        gridBagConstraints.fill = 2;
        this.headerFieldsPanel.add((Component)nameTF, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.headerGridY;
        gridBagConstraints.fill = 2;
        this.headerFieldsPanel.add((Component)valueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = this.headerGridY++;
        gridBagConstraints.fill = 0;
        this.headerFieldsPanel.add((Component)removeButton, gridBagConstraints);
        this.validate();
        return removeButton;
    }

    public SecuritySettingsPanel getSecuritySettingsPanel() {
        return this.securitySettingsPanel;
    }

    public void setSecuritySettingsPanel(SecuritySettingsPanel securitySettingsPanel) {
        this.securitySettingsPanel = securitySettingsPanel;
    }

    private void removeHeaderActionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JButton) {
            if (this.headerFields.size() == 1) {
                this.headerFieldName.setVisible(false);
                this.headerFieldValue.setVisible(false);
            }
            JTextField nameTF = this.removeButtons.get(source);
            JTextField valueTF = this.headerFields.get(nameTF);
            this.headerFields.remove(nameTF);
            this.headerFieldsPanel.remove(nameTF);
            this.headerFieldsPanel.remove(valueTF);
            this.headerFieldsPanel.remove((JButton)source);
            this.validate();
        }
    }

    private void emptySubjectActionPerformed(ChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JCheckBox) {
            if (this.cbSuppressSubject.isSelected()) {
                this.tfSubject.setEnabled(false);
                this.cbIncludeTimestamp.setEnabled(false);
            } else {
                this.tfSubject.setEnabled(true);
                this.cbIncludeTimestamp.setEnabled(true);
            }
        }
    }
}

