/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.Paint;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.ScatterPlotAxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.ScatterPlotDataSeries;
import org.jCharts.imageMap.ImageMap;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

abstract class ScatterChartTestBase {
    public ScatterChartTestBase() {
        System.out.println("Running: " + this.getClass().getName());
    }

    abstract ScatterPlotDataSeries getDataSeries() throws ChartDataException;

    abstract boolean supportsImageMap();

    static void axisChartTest(String string, ScatterChartTestBase scatterChartTestBase) throws ChartDataException, PropertyException {
        int n = 10;
        HTMLGenerator hTMLGenerator = new HTMLGenerator("" + string + "Test.html");
        int n2 = 0;
        while (n2 < n) {
            ImageMap imageMap;
            ScatterPlotDataSeries scatterPlotDataSeries = scatterChartTestBase.getDataSeries();
            boolean bl = false;
            boolean bl2 = true;
            AxisProperties axisProperties = new AxisProperties(new DataAxisProperties(), new DataAxisProperties());
            axisProperties.setXAxisLabelsAreVertical(TestDataGenerator.getRandomNumber(1.0) > 0.5);
            TestDataGenerator.randomizeAxisProperties(axisProperties);
            DataAxisProperties dataAxisProperties = bl ? (DataAxisProperties)axisProperties.getXAxisProperties() : (DataAxisProperties)axisProperties.getYAxisProperties();
            dataAxisProperties.setRoundToNearest(1);
            dataAxisProperties.setShowAxisLabels(TestDataGenerator.getRandomNumber(1.0) > 0.5);
            int n3 = (int)TestDataGenerator.getRandomNumber(500.0, 1000.0);
            int n4 = (int)TestDataGenerator.getRandomNumber(300.0, 800.0);
            LegendProperties legendProperties = new LegendProperties();
            ChartProperties chartProperties = new ChartProperties();
            ScatterPlotAxisChart scatterPlotAxisChart = new ScatterPlotAxisChart(scatterPlotDataSeries, chartProperties, axisProperties, legendProperties, n3, n4);
            String string2 = "" + string + n2 + ".png";
            if (bl2 && scatterChartTestBase.supportsImageMap()) {
                scatterPlotAxisChart.renderWithImageMap();
                imageMap = scatterPlotAxisChart.getImageMap();
            } else {
                imageMap = null;
            }
            try {
                ChartTestDriver.exportImage(scatterPlotAxisChart, string2);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                System.out.println();
            }
            ((AxisChart)scatterPlotAxisChart).toHTML(hTMLGenerator, string2, imageMap);
            hTMLGenerator.addLineBreak();
            ++n2;
        }
        hTMLGenerator.saveFile();
    }

    final DataSeries createDataSeries(int n) {
        String[] stringArray = null;
        if (TestDataGenerator.getRandomNumber(1.0) > 0.5) {
            stringArray = TestDataGenerator.getRandomStrings(n, (int)TestDataGenerator.getRandomNumber(10.0), false);
        }
        String string = TestDataGenerator.getRandomString(15, true);
        String string2 = TestDataGenerator.getRandomString(15, true);
        return new DataSeries(stringArray, string, string2, "This is a test title that is so freaking long is is going to wrap around the image for sure. lfksjg;ljs; dflgkjdfgsdgdg dsgdsgsdfg dsfgsdfgsdfgs dfgdsfgd");
    }

    AxisChartDataSet createAxisChartDataSet(ChartType chartType, ChartTypeProperties chartTypeProperties, int n, int n2, int n3, int n4) throws ChartDataException {
        double[][] dArray = TestDataGenerator.getRandomNumbers(n, n2, n3, n4);
        String[] stringArray = TestDataGenerator.getRandomStrings(n, 10, false);
        Paint[] paintArray = TestDataGenerator.getRandomPaints(n);
        return new AxisChartDataSet(dArray, stringArray, paintArray, chartType, chartTypeProperties);
    }
}

