/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.net.URI;
import java.util.function.Supplier;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.internal.StringUtils;

public class BasicUriHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private URI parsed;

    public static BasicUriHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicUriHeader(name, value);
    }

    public static BasicUriHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicUriHeader(name, value);
    }

    public BasicUriHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    public URI asURI() {
        return this.getParsedValue();
    }

    private URI getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        return URI.create(o.toString());
    }
}

