/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.LinkString;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.exception.Forbidden;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.MethodNotAllowed;
import org.apache.juneau.http.exception.NotFound;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.rest.BasicRestServlet;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.helper.SeeOtherRoot;
import org.apache.juneau.utils.IOPipe;

@Rest(title={"File System Explorer"}, messages="nls/DirectoryResource", allowedMethodParams="*")
@HtmlDocConfig(navlinks={"up: request:/..", "options: servlet:/?method=OPTIONS"})
@HtmlConfig(uriAnchorText="PROPERTY_NAME")
public class DirectoryResource
extends BasicRestServlet {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "DirectoryResource.";
    public static final String DIRECTORY_RESOURCE_rootDir = "DirectoryResource.rootDir.s";
    public static final String DIRECTORY_RESOURCE_allowViews = "DirectoryResource.allowViews.b";
    public static final String DIRECTORY_RESOURCE_allowDeletes = "DirectoryResource.allowDeletes.b";
    public static final String DIRECTORY_RESOURCE_allowUploads = "DirectoryResource.allowUploads.b";
    private File rootDir;
    boolean allowDeletes;
    boolean allowUploads;
    boolean allowViews;

    @RestHook(value=HookEvent.INIT)
    public void init(RestContextBuilder b) throws Exception {
        RestContextProperties p = b.getProperties();
        this.rootDir = new File(p.getString(DIRECTORY_RESOURCE_rootDir));
        this.allowViews = p.getBoolean(DIRECTORY_RESOURCE_allowViews, false);
        this.allowDeletes = p.getBoolean(DIRECTORY_RESOURCE_allowDeletes, false);
        this.allowUploads = p.getBoolean(DIRECTORY_RESOURCE_allowUploads, false);
    }

    @RestMethod(name="GET", path="/*", summary="View information on file or directory", description={"Returns information about the specified file or directory."})
    @HtmlDocConfig(nav={"<h5>Folder:  $RA{fullPath}</h5>"})
    public FileResource getFile(RestRequest req, @Path(value="/*") String path) throws NotFound, Exception {
        File dir = this.getFile(path);
        req.setAttribute("fullPath", dir.getAbsolutePath());
        return new FileResource(dir, path, true);
    }

    @RestMethod(name="VIEW", path="/*", summary="View contents of file", description={"View the contents of a file.\nContent-Type is set to 'text/plain'."})
    public FileContents viewFile(RestResponse res, @Path(value="/*") String path) throws NotFound, MethodNotAllowed {
        if (!this.allowViews) {
            throw new MethodNotAllowed("VIEW not enabled");
        }
        res.setContentType("text/plain");
        try {
            return new FileContents(this.getFile(path));
        }
        catch (FileNotFoundException e) {
            throw new NotFound("File not found");
        }
    }

    @RestMethod(name="DOWNLOAD", path="/*", summary="Download file", description={"Download the contents of a file.\nContent-Type is set to 'application/octet-stream'."})
    public FileContents downloadFile(RestResponse res, @Path(value="/*") String path) throws NotFound, MethodNotAllowed {
        if (!this.allowViews) {
            throw new MethodNotAllowed("DOWNLOAD not enabled");
        }
        res.setContentType("application/octet-stream");
        try {
            return new FileContents(this.getFile(path));
        }
        catch (FileNotFoundException e) {
            throw new NotFound("File not found");
        }
    }

    @RestMethod(name="DELETE", path="/*", summary="Delete file", description={"Delete a file on the file system."})
    public RedirectToRoot deleteFile(@Path(value="/*") String path) throws MethodNotAllowed {
        this.deleteFile(this.getFile(path));
        return new RedirectToRoot();
    }

    @RestMethod(name="PUT", path="/*", summary="Add or replace file", description={"Add or overwrite a file on the file system."})
    public RedirectToRoot updateFile(@Body(schema=@Schema(type="string", format="binary")) InputStream is, @Path(value="/*") String path) throws InternalServerError {
        if (!this.allowUploads) {
            throw new MethodNotAllowed("PUT not enabled");
        }
        File f = this.getFile(path);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
            IOPipe.create(is, os).run();
        }
        catch (IOException e) {
            throw new InternalServerError(e);
        }
        return new RedirectToRoot();
    }

    protected File getRootDir() {
        return this.rootDir;
    }

    private File getFile(String path) throws NotFound {
        if (path == null) {
            return this.rootDir;
        }
        File f = new File(this.rootDir.getAbsolutePath() + '/' + path);
        if (f.exists()) {
            return f;
        }
        throw new NotFound("File not found.");
    }

    private void deleteFile(File f) {
        File[] files;
        if (!this.allowDeletes) {
            throw new MethodNotAllowed("DELETE not enabled");
        }
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File fc : files) {
                this.deleteFile(fc);
            }
        }
        if (!f.delete()) {
            throw new Forbidden("Could not delete file {0}", f.getAbsolutePath());
        }
    }

    static final class FileResourceComparator
    implements Comparator<FileResource>,
    Serializable {
        private static final long serialVersionUID = 1L;

        FileResourceComparator() {
        }

        @Override
        public int compare(FileResource o1, FileResource o2) {
            int c = o1.getType().compareTo(o2.getType());
            return c != 0 ? c : o1.getName().compareTo(o2.getName());
        }
    }

    @Response(description={"File or directory details"})
    @Bean(bpi="type,name,size,lastModified,actions,files")
    public class FileResource {
        private final File f;
        private final String path;
        private final String uri;
        private final boolean includeChildren;

        public FileResource(File f, String path, boolean includeChildren) {
            this.f = f;
            this.path = path;
            this.uri = "servlet:/" + (path == null ? "" : path);
            this.includeChildren = includeChildren;
        }

        public String getType() {
            return this.f.isDirectory() ? "dir" : "file";
        }

        public LinkString getName() {
            return new LinkString(this.f.getName(), this.uri, new Object[0]);
        }

        public long getSize() {
            return this.f.isDirectory() ? (long)this.f.listFiles().length : this.f.length();
        }

        public Date getLastModified() {
            return new Date(this.f.lastModified());
        }

        @Html(format=HtmlFormat.HTML_CDC)
        public List<Action> getActions() throws Exception {
            ArrayList<Action> l = new ArrayList<Action>();
            if (DirectoryResource.this.allowViews && this.f.canRead() && !this.f.isDirectory()) {
                l.add(new Action("view", this.uri + "?method=VIEW", new Object[0]));
                l.add(new Action("download", this.uri + "?method=DOWNLOAD", new Object[0]));
            }
            if (DirectoryResource.this.allowDeletes && this.f.canWrite() && !this.f.isDirectory()) {
                l.add(new Action("delete", this.uri + "?method=DELETE", new Object[0]));
            }
            return l;
        }

        public Set<FileResource> getFiles() {
            if (this.f.isFile() || !this.includeChildren) {
                return null;
            }
            TreeSet<FileResource> s = new TreeSet<FileResource>(new FileResourceComparator());
            for (File fc : this.f.listFiles()) {
                s.add(new FileResource(fc, (this.path != null ? this.path + '/' : "") + StringUtils.urlEncode(fc.getName()), false));
            }
            return s;
        }
    }

    @Response(description={"File action"})
    public static class Action
    extends LinkString {
        public Action(String name, String uri, Object ... uriArgs) {
            super(name, uri, uriArgs);
        }
    }

    @Response(description={"Redirect to root page on success"})
    static class RedirectToRoot
    extends SeeOtherRoot {
        RedirectToRoot() {
        }
    }

    @Response(schema=@Schema(type="string", format="binary"), description={"Contents of file"})
    static class FileContents
    extends FileInputStream {
        public FileContents(File file) throws FileNotFoundException {
            super(file);
        }
    }
}

